/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.handler.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.SironaException;
import org.apache.sirona.reporting.web.handler.TemplateHelper;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Template;

public class Invoker {
    public static final String TEXT_HTML = "text/html";
    private final Object instance;
    private final Method method;
    private final String name;
    private final List<ParameterExtractor<?>> parameters = new CopyOnWriteArrayList();

    public Invoker(Object instance, Method method, String name) {
        this.instance = instance;
        this.method = method;
        this.name = name;
    }

    public void invoke(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
        Object[] params = new Object[this.parameters.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.parameters.get(i).extract(request, response, matcher);
        }
        try {
            Object result = this.method.invoke(this.instance, params);
            if (Template.class.isInstance(result)) {
                Template template = (Template)Template.class.cast(result);
                this.populateRequestParameters(template, request);
                TemplateHelper helper = new TemplateHelperExtractor(this.name).extract(request, response, matcher);
                if (template.isHtml()) {
                    response.setContentType(TEXT_HTML);
                    helper.renderHtml(template.getTemplate(), template.getUserParams());
                } else {
                    helper.renderPlain(template.getTemplate(), template.getUserParams());
                }
            } else if (result != null) {
                response.getWriter().write(result.toString());
            }
        }
        catch (InvocationTargetException e) {
            throw new SironaException(e.getCause());
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    private void populateRequestParameters(Template template, HttpServletRequest request) {
        Map<String, String> requestParameters = this.extractRequestParameters(request);
        for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
            template.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    private Map<String, String> extractRequestParameters(HttpServletRequest request) {
        HashMap<String, String> requestParameters = new HashMap<String, String>(request.getParameterMap().size());
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = request.getParameter(key);
            requestParameters.put(key, value);
        }
        return requestParameters;
    }

    public void addRequestParameter() {
        this.parameters.add(new RequestExtractor());
    }

    public void addResponseParameter() {
        this.parameters.add(new ResponseExtractor());
    }

    public void addTemplateHelper(String plugin) {
        this.parameters.add(new TemplateHelperExtractor(plugin));
    }

    public void addSegmentParameter(Class<?> clazz, int partIdx) {
        if (String.class.equals(clazz)) {
            this.parameters.add(new StringSegmentExtractor(partIdx));
        } else if (Long.TYPE.equals(clazz)) {
            this.parameters.add(new LongSegmentExtractor(partIdx));
        } else if (Integer.TYPE.equals(clazz)) {
            this.parameters.add(new IntSegmentExtractor(partIdx));
        } else if (String[].class.equals(clazz)) {
            this.parameters.add(new StringArraySegmentExtractor(partIdx));
        } else {
            throw new IllegalArgumentException(clazz.getName() + " not handled");
        }
    }

    public String toString() {
        return "Invoker{" + this.method + '}';
    }

    protected static class IntSegmentExtractor
    implements ParameterExtractor<Integer> {
        private final int index;

        public IntSegmentExtractor(int index) {
            this.index = index;
        }

        @Override
        public Integer extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            return Integer.parseInt(matcher.group(this.index));
        }
    }

    protected static class LongSegmentExtractor
    implements ParameterExtractor<Long> {
        private final int index;

        public LongSegmentExtractor(int index) {
            this.index = index;
        }

        @Override
        public Long extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            return Long.parseLong(matcher.group(this.index));
        }
    }

    protected static class StringArraySegmentExtractor
    implements ParameterExtractor<String[]> {
        private final int index;

        public StringArraySegmentExtractor(int index) {
            this.index = index;
        }

        @Override
        public String[] extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            return matcher.group(this.index).split("/");
        }
    }

    protected static class StringSegmentExtractor
    implements ParameterExtractor<String> {
        private final int index;

        public StringSegmentExtractor(int index) {
            this.index = index;
        }

        @Override
        public String extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            return matcher.group(this.index);
        }
    }

    protected static class ResponseExtractor
    implements ParameterExtractor<HttpServletResponse> {
        protected ResponseExtractor() {
        }

        @Override
        public HttpServletResponse extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            return response;
        }
    }

    protected static class RequestExtractor
    implements ParameterExtractor<HttpServletRequest> {
        protected RequestExtractor() {
        }

        @Override
        public HttpServletRequest extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            return request;
        }
    }

    protected static class TemplateHelperExtractor
    implements ParameterExtractor<TemplateHelper> {
        private final String plugin;

        public TemplateHelperExtractor(String plugin) {
            this.plugin = plugin;
        }

        @Override
        public TemplateHelper extract(HttpServletRequest request, HttpServletResponse response, Matcher matcher) {
            try {
                return new TemplateHelper(response.getWriter(), new MapBuilder().set((Object)"templateId", (Object)this.plugin).build());
            }
            catch (IOException e) {
                throw new SironaException((Throwable)e);
            }
        }
    }

    protected static interface ParameterExtractor<T> {
        public T extract(HttpServletRequest var1, HttpServletResponse var2, Matcher var3);
    }
}

