/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import org.apache.sirona.Role;
import org.apache.sirona.gauges.jvm.ActiveThreadGauge;
import org.apache.sirona.gauges.jvm.CPUGauge;
import org.apache.sirona.gauges.jvm.UsedMemoryGauge;
import org.apache.sirona.gauges.jvm.UsedNonHeapMemoryGauge;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.api.graph.Graphs;
import org.apache.sirona.util.Environment;

public class JVMEndpoints {
    @Regex
    public Template home() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!Environment.isCollector()) {
            params.put("architecture", os.getArch());
            params.put("name", os.getName());
            params.put("version", os.getVersion());
            params.put("numberProcessor", os.getAvailableProcessors());
            params.put("maxMemory", memory.getHeapMemoryUsage().getMax());
            params.put("initMemory", memory.getHeapMemoryUsage().getInit());
            params.put("maxNonHeapMemory", memory.getNonHeapMemoryUsage().getMax());
            params.put("initNonHeapMemory", memory.getNonHeapMemoryUsage().getInit());
        }
        return new Template("jvm/jvm.vm", params);
    }

    @Regex(value="/cpu/([0-9]*)/([0-9]*)")
    public String cpu(long start, long end) {
        return Graphs.generateReport((String)"CPU Usage", (Role)CPUGauge.CPU, (long)start, (long)end);
    }

    @Regex(value="/memory/([0-9]*)/([0-9]*)")
    public String memory(long start, long end) {
        return Graphs.generateReport((String)"Used Memory", (Role)UsedMemoryGauge.USED_MEMORY, (long)start, (long)end);
    }

    @Regex(value="/nonheapmemory/([0-9]*)/([0-9]*)")
    public String nonHeapmemory(long start, long end) {
        return Graphs.generateReport((String)"Used Non Heap Memory", (Role)UsedNonHeapMemoryGauge.USED_NONHEAPMEMORY, (long)start, (long)end);
    }

    @Regex(value="/activethreads/([0-9]*)/([0-9]*)")
    public String activeThreads(long start, long end) {
        return Graphs.generateReport((String)"Active Thread Count", (Role)ActiveThreadGauge.ACTIVE_THREAD, (long)start, (long)end);
    }
}

