/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.report.format;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.MetricData;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.repositories.Repository;

public abstract class MapFormat {
    public static final String ENCODING = "UTF-8";
    public static final Collection<String> ATTRIBUTES_ORDERED_LIST = MapFormat.buildMetricDataHeader();

    protected static Collection<String> buildMetricDataHeader() {
        CopyOnWriteArrayList<String> list = new CopyOnWriteArrayList<String>();
        list.add("Counter");
        list.add("Role");
        for (MetricData md : MetricData.values()) {
            list.add(md.name());
        }
        return list;
    }

    public static String format(Map<String, ?> params, String defaultValue) {
        if (params == null) {
            return defaultValue;
        }
        Object format = params.get("format");
        if (format != null) {
            if (String.class.isInstance(format)) {
                String strFormat = (String)String.class.cast(format);
                return MapFormat.decode(strFormat);
            }
            if (String[].class.isInstance(format)) {
                String[] array = (String[])String[].class.cast(format);
                return MapFormat.decode(array[0]);
            }
        }
        return defaultValue;
    }

    private static String decode(String strFormat) {
        try {
            return URLDecoder.decode(strFormat, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return strFormat;
        }
    }

    public static Unit timeUnit(Map<String, ?> params) {
        if (params == null) {
            return Unit.Time.MILLISECOND;
        }
        Object u = params.get("unit");
        if (u != null) {
            Unit unit;
            String[] array;
            Unit unit2;
            if (String.class.isInstance(u) && (unit2 = Unit.get((String)((String)String.class.cast(u)).toLowerCase())) != null) {
                return unit2;
            }
            if (String[].class.isInstance(u) && (array = (String[])String[].class.cast(u)).length > 0 && (unit = Unit.get((String)array[0].toLowerCase())) != null) {
                return unit;
            }
        }
        return Unit.Time.MILLISECOND;
    }

    protected static Map<String, Collection<String>> snapshotByPath(Unit timeUnit, String format) {
        TreeMap<String, Collection<String>> data = new TreeMap<String, Collection<String>>();
        for (Counter counter : Repository.INSTANCE.counters()) {
            Counter.Key key = counter.getKey();
            data.put(MapFormat.generateCounterKeyString(key), MapFormat.generateLine(counter, timeUnit, format));
        }
        return data;
    }

    public static String generateCounterKeyString(Counter.Key key) {
        Role role = key.getRole();
        try {
            return MapFormat.encode(role.getName()) + '/' + role.getUnit().getName() + "?name=" + MapFormat.encode(key.getName());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static Collection<Collection<String>> snapshot(Unit timeUnit, String format) {
        ArrayList<Collection<String>> data = new ArrayList<Collection<String>>();
        for (Counter counter : Repository.INSTANCE.counters()) {
            data.add(MapFormat.generateLine(counter, timeUnit, format));
        }
        return data;
    }

    public static Collection<String> generateLine(Counter counter, Unit timeUnit, String format) {
        Unit counterUnit = counter.getKey().getRole().getUnit();
        boolean compatible = timeUnit.isCompatible(counterUnit);
        ArrayList<String> line = new ArrayList<String>();
        line.add(counter.getKey().getName());
        if (compatible) {
            line.add(counter.getKey().getRole().getName() + " (" + timeUnit.getName() + ")");
        } else {
            line.add(counter.getKey().getRole().getName() + " (" + counterUnit.getName() + ")");
        }
        DecimalFormat formatter = format != null ? new DecimalFormat(format) : null;
        for (MetricData md : MetricData.values()) {
            double value = md.value(counter);
            if (md.isTime() && compatible && timeUnit != counterUnit) {
                value = timeUnit.convert(value, counterUnit);
            }
            if (formatter != null && !Double.isNaN(value) && !Double.isInfinite(value)) {
                line.add(formatter.format(value));
                continue;
            }
            line.add(Double.toString(value));
        }
        return line;
    }

    private static String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, ENCODING);
    }
}

