/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.status;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.status.StatusHelper;
import org.apache.sirona.repositories.Repository;

public class StatusEndpoints {
    private static final String DEFAULT_ROOT = "-";
    private static final String APP_DELIMITER = "#";

    @Regex
    public Template home() {
        HashMap statusesByApp = new HashMap();
        for (Map.Entry entry : Repository.INSTANCE.statuses().entrySet()) {
            String key = (String)entry.getKey();
            String[] segments = key.contains(APP_DELIMITER) ? key.split(APP_DELIMITER) : new String[]{DEFAULT_ROOT, key};
            TreeMap statusesOfTheApp = (TreeMap)statusesByApp.get(segments[0]);
            if (statusesOfTheApp == null) {
                statusesOfTheApp = new TreeMap();
                statusesByApp.put(segments[0], statusesOfTheApp);
            }
            statusesOfTheApp.put(segments[1], entry.getValue());
        }
        return new Template("status/home.vm").set("helper", StatusHelper.class).set("apps", statusesByApp);
    }

    @Regex(value="/([^/]*)")
    public Template detail(String node) {
        return new Template("status/detail.vm").set("helper", StatusHelper.class).set("node", Repository.INSTANCE.statuses().get(node)).set("name", (Object)node);
    }
}

