/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableIF;

final class VariableWrapper
extends Variable {
    private final VariableIF variable;

    VariableWrapper(VariableIF variableIF) {
        this.variable = variableIF;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return this.variable.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.variable.getUnitsString();
    }

    @Override
    public DataType getDataType() {
        DataType dataType;
        switch (this.variable.getDataType()) {
            case STRING: {
                return DataType.STRING;
            }
            case CHAR: {
                return DataType.CHAR;
            }
            case BYTE: {
                dataType = DataType.BYTE;
                break;
            }
            case SHORT: {
                dataType = DataType.SHORT;
                break;
            }
            case INT: {
                dataType = DataType.INT;
                break;
            }
            case LONG: {
                dataType = DataType.INT64;
                break;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            default: {
                return DataType.UNKNOWN;
            }
        }
        return dataType.unsigned(this.variable.isUnsigned());
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        return this.variable.isCoordinateVariable();
    }

    @Override
    public String[] getGridDimensionNames() {
        List list = this.variable.getDimensions();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Dimension)list.get(i)).getShortName();
        }
        return stringArray;
    }

    @Override
    public int[] getGridEnvelope() {
        return this.variable.getShape();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.variable.getAttributes());
    }

    @Override
    public Object[] getAttributeValues(String string, boolean bl) {
        Attribute attribute = this.variable.findAttributeIgnoreCase(string);
        if (attribute != null) {
            boolean bl2 = false;
            Object[] objectArray = new Object[attribute.getLength()];
            for (int i = 0; i < objectArray.length; ++i) {
                String string2;
                if (bl) {
                    objectArray[i] = attribute.getNumericValue(i);
                    if (objectArray[i] == null) continue;
                    bl2 = true;
                    continue;
                }
                Object object = attribute.getValue(i);
                if (object == null || (string2 = object.toString().trim()).isEmpty()) continue;
                objectArray[i] = string2;
                bl2 = true;
            }
            if (bl2) {
                return objectArray;
            }
        }
        return new Object[0];
    }

    static List<String> toNames(List<Attribute> list) {
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = list.get(i).getShortName();
        }
        return UnmodifiableArrayList.wrap((Object[])objectArray);
    }

    @Override
    public Vector read() throws IOException {
        Array array = this.variable.read();
        return Vector.create((Object)array.get1DJavaArray(array.getElementType()), (boolean)this.variable.isUnsigned());
    }

    @Override
    public Vector read(int[] nArray, int[] nArray2, int[] nArray3) throws IOException, DataStoreException {
        Array array;
        int[] nArray4 = new int[nArray2.length];
        for (int i = 0; i < nArray4.length; ++i) {
            nArray4[i] = nArray2[i] - nArray[i];
        }
        try {
            array = this.variable.read(new Section(nArray, nArray4, nArray3));
        }
        catch (InvalidRangeException invalidRangeException) {
            throw new DataStoreContentException((Throwable)invalidRangeException);
        }
        return Vector.create((Object)array.get1DJavaArray(array.getElementType()), (boolean)this.variable.isUnsigned());
    }
}

