/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.NetcdfStore;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.classic.ChannelDecoder;
import org.apache.sis.storage.netcdf.internal.Resources;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="NetCDF", fileSuffixes={"nc"}, capabilities={Capability.READ}, resourceTypes={Aggregate.class, FeatureSet.class, GridCoverageResource.class}, yieldPriority=true)
public class NetcdfStoreProvider
extends DataStoreProvider {
    static final String NAME = "NetCDF";
    static final String MIME_TYPE = "application/x-netcdf";
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor((String)"NetCDF");
    private static final String UCAR_CLASSNAME = "ucar.nc2.NetcdfFile";
    private static final String FACTORY_CLASSNAME = "ucar.nc2.NetcdfFiles";
    private static Class<?> netcdfFileClass;
    private static volatile Method canOpenFromPath;
    private static volatile Constructor<? extends Decoder> createFromPath;
    private static volatile Constructor<? extends Decoder> createFromUCAR;

    public String getShortName() {
        return NAME;
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    private static boolean ignoredExtension(String extension) {
        return extension != null && (extension.regionMatches(true, 0, "gbx", 0, 3) || extension.regionMatches(true, 0, "ncx", 0, 3));
    }

    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        if (NetcdfStoreProvider.ignoredExtension(IOUtilities.extension((Object)connector.getStorage()))) {
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
        int version = 0;
        boolean hasVersion = false;
        boolean isSupported = false;
        ByteBuffer buffer = (ByteBuffer)connector.getStorageAs(ByteBuffer.class);
        if (buffer != null) {
            if (buffer.remaining() < 4) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            int header = (buffer = buffer.duplicate()).getInt();
            if ((header & 0xFFFFFF00) == 1128547840) {
                hasVersion = true;
                version = header & 0xFF;
                boolean bl = isSupported = version >= 1 && version <= 2;
            }
        }
        if (!isSupported) {
            String path = (String)connector.getStorageAs(String.class);
            if (path != null) {
                NetcdfStoreProvider.ensureInitialized(false);
                Method method = canOpenFromPath;
                if (method != null) {
                    try {
                        isSupported = (Boolean)method.invoke(null, path);
                    }
                    catch (IllegalAccessException e) {
                        throw (Error)new IncompatibleClassChangeError("canOpen").initCause(e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof DataStoreException) {
                            throw (DataStoreException)cause;
                        }
                        if (cause instanceof IOException) {
                            Logging.recoverableException((Logger)this.getLogger(), NetcdfStoreProvider.class, (String)"probeContent", (Throwable)cause);
                            return ProbeResult.UNSUPPORTED_STORAGE;
                        }
                        throw new CanNotProbeException((DataStoreProvider)this, connector, cause);
                    }
                }
            } else {
                for (Class<?> type = connector.getStorage().getClass(); type != null; type = type.getSuperclass()) {
                    if (!UCAR_CLASSNAME.equals(type.getName())) continue;
                    isSupported = true;
                    break;
                }
            }
        }
        if (hasVersion) {
            return new ProbeResult(isSupported, MIME_TYPE, Version.valueOf((int[])new int[]{version}));
        }
        return isSupported ? new ProbeResult(true, MIME_TYPE, null) : ProbeResult.UNSUPPORTED_STORAGE;
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new NetcdfStore(this, connector);
    }

    static Decoder decoder(StoreListeners listeners, StorageConnector connector) throws IOException, DataStoreException {
        Object keepOpen;
        Decoder decoder;
        GeometryLibrary geomlib = (GeometryLibrary)connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        ChannelDataInput input = (ChannelDataInput)connector.getStorageAs(ChannelDataInput.class);
        if (input != null) {
            try {
                decoder = new ChannelDecoder(input, (Charset)connector.getOption(OptionKey.ENCODING), geomlib, listeners);
                keepOpen = input;
            }
            catch (ArithmeticException | DataStoreException e) {
                String path = (String)connector.getStorageAs(String.class);
                if (path != null) {
                    try {
                        decoder = NetcdfStoreProvider.createByReflection(path, false, geomlib, listeners);
                        keepOpen = path;
                    }
                    catch (IOException | DataStoreException s) {
                        e.addSuppressed(s);
                        throw e;
                    }
                }
                throw e;
            }
        } else {
            keepOpen = connector.getStorage();
            decoder = NetcdfStoreProvider.createByReflection(keepOpen, true, geomlib, listeners);
        }
        connector.closeAllExcept(decoder != null ? keepOpen : null);
        if (decoder != null) {
            decoder.applyOtherConventions();
        }
        return decoder;
    }

    private static Decoder createByReflection(Object input, boolean isUCAR, GeometryLibrary geomlib, StoreListeners listeners) throws IOException, DataStoreException {
        Class<Object> expectedType;
        Constructor<? extends Decoder> constructor;
        NetcdfStoreProvider.ensureInitialized(true);
        if (isUCAR) {
            constructor = createFromUCAR;
            expectedType = netcdfFileClass;
        } else {
            constructor = createFromPath;
            expectedType = String.class;
        }
        if (constructor == null || !expectedType.isInstance(input)) {
            return null;
        }
        try {
            return constructor.newInstance(input, geomlib, listeners);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof DataStoreException) {
                throw (DataStoreException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalDataStoreException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized(boolean open) {
        if (netcdfFileClass != null) return;
        Level severity = null;
        Throwable cause = null;
        Class<NetcdfStoreProvider> clazz = NetcdfStoreProvider.class;
        synchronized (NetcdfStoreProvider.class) {
            try {
                netcdfFileClass = Class.forName(UCAR_CLASSNAME);
                Class<?> netcdfFactoryClass = Class.forName(FACTORY_CLASSNAME);
                canOpenFromPath = netcdfFactoryClass.getMethod("canOpen", String.class);
                if (canOpenFromPath.getReturnType() == Boolean.TYPE) {
                    Class<Decoder> wrapper = Class.forName("org.apache.sis.storage.netcdf.ucar.DecoderWrapper").asSubclass(Decoder.class);
                    Class[] parameterTypes = new Class[]{netcdfFileClass, GeometryLibrary.class, StoreListeners.class};
                    createFromUCAR = wrapper.getConstructor(parameterTypes);
                    parameterTypes[0] = String.class;
                    createFromPath = wrapper.getConstructor(parameterTypes);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                severity = Level.CONFIG;
            }
            catch (NoClassDefFoundError | ReflectiveOperationException e) {
                severity = Level.WARNING;
                cause = e;
            }
            NetcdfStoreProvider.reset();
            netcdfFileClass = Void.TYPE;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            LogRecord record = Resources.forLocale(null).getLogRecord(severity, (short)4);
            record.setThrown(cause);
            Logging.completeAndLog((Logger)Decoder.LOGGER, NetcdfStoreProvider.class, (String)(open ? "open" : "probeContent"), (LogRecord)record);
            return;
        }
    }

    static synchronized void reset() {
        netcdfFileClass = null;
        canOpenFromPath = null;
        createFromUCAR = null;
        createFromPath = null;
    }

    public Logger getLogger() {
        return Decoder.LOGGER;
    }

    static {
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.storage.netcdf"){

            protected void classpathChanged() {
                NetcdfStoreProvider.reset();
            }
        });
    }
}

