/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.logservice.internal;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.commons.logservice.internal.LogEntryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogSupport
implements SynchronousBundleListener,
ServiceListener,
FrameworkListener {
    private static final String COMPONENT_NAME = "component.name";
    private final Enumeration<?> EMPTY = Collections.enumeration(Collections.emptyList());
    private LogListenerProxy[] listeners;
    private final Object listenersLock = new Object();
    private Map<Long, Logger> loggers = new LinkedHashMap<Long, Logger>(16, 0.75f, true){
        private static final int MAX_SIZE = 50;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Logger> eldest) {
            return this.size() > 50;
        }
    };
    private LogEntryDispatcher logEntryDispatcher = new LogEntryDispatcher(this);

    LogSupport() {
        this.logEntryDispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.logEntryDispatcher.terminate();
        try {
            this.logEntryDispatcher.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLogListener(Bundle bundle, LogListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            LogListenerProxy llp = new LogListenerProxy(bundle, listener);
            if (this.listeners == null) {
                this.listeners = new LogListenerProxy[]{llp};
            } else if (this.getListener(listener) < 0) {
                LogListenerProxy[] newListeners = new LogListenerProxy[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
                newListeners[this.listeners.length] = llp;
                this.listeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLogListener(LogListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            int idx = this.getListener(listener);
            if (idx < 0) {
                return;
            }
            LogListenerProxy[] newListeners = new LogListenerProxy[this.listeners.length - 1];
            if (idx > 0) {
                System.arraycopy(this.listeners, 0, newListeners, 0, idx);
            }
            if (idx < this.listeners.length) {
                System.arraycopy(this.listeners, idx + 1, newListeners, 0, newListeners.length - idx);
            }
            this.listeners = newListeners;
        }
    }

    void removeLogListeners(Bundle bundle) {
        LogListenerProxy[] current = this.getListeners();
        if (current == null) {
            return;
        }
        for (int i = 0; i < current.length; ++i) {
            if (!current[i].hasBundle(bundle)) continue;
            this.removeLogListener(current[i]);
        }
    }

    private int getListener(LogListener listener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (!this.listeners[i].isSame(listener)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogListenerProxy[] getListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            return this.listeners;
        }
    }

    Enumeration<?> getLog() {
        return this.EMPTY;
    }

    void fireLogEvent(LogEntry logEntry) {
        this.logOut(logEntry);
        this.logEntryDispatcher.enqueLogEntry(logEntry);
    }

    public void bundleChanged(BundleEvent event) {
        String message;
        switch (event.getType()) {
            case 1: {
                message = "BundleEvent INSTALLED";
                break;
            }
            case 32: {
                message = "BundleEvent RESOLVED";
                break;
            }
            case 128: {
                message = "BundleEvent STARTING";
                break;
            }
            case 2: {
                message = "BundleEvent STARTED";
                break;
            }
            case 256: {
                message = "BundleEvent STOPPING";
                break;
            }
            case 4: {
                this.removeLogListeners(event.getBundle());
                message = "BundleEvent STOPPED";
                break;
            }
            case 64: {
                message = "BundleEvent UNRESOLVED";
                break;
            }
            case 8: {
                message = "BundleEvent UPDATED";
                break;
            }
            case 16: {
                this.ungetLogger(event.getBundle());
                message = "BundleEvent UNINSTALLED";
                break;
            }
            default: {
                message = "BundleEvent " + event.getType();
            }
        }
        LogEntryImpl entry = new LogEntryImpl(event.getBundle(), null, 3, message, null);
        this.fireLogEvent(entry);
    }

    public void serviceChanged(ServiceEvent event) {
        String message;
        int level = 3;
        switch (event.getType()) {
            case 1: {
                message = "ServiceEvent REGISTERED";
                break;
            }
            case 2: {
                message = "ServiceEvent MODIFIED";
                level = 4;
                break;
            }
            case 4: {
                message = "ServiceEvent UNREGISTERING";
                break;
            }
            default: {
                message = "ServiceEvent " + event.getType();
            }
        }
        String s = event.getServiceReference().getBundle() == null ? null : "Bundle " + event.getServiceReference().getBundle();
        s = s == null ? message : s + " " + message;
        LogEntryImpl entry = new LogEntryImpl(event.getServiceReference().getBundle(), event.getServiceReference(), level, message, null);
        this.fireLogEvent(entry);
    }

    public void frameworkEvent(FrameworkEvent event) {
        String message;
        int level = 3;
        Throwable exception = event.getThrowable();
        switch (event.getType()) {
            case 1: {
                message = "FrameworkEvent STARTED";
                break;
            }
            case 2: {
                StackTraceElement[] ste;
                message = "FrameworkEvent ERROR";
                if (exception instanceof BundleException && (ste = exception.getStackTrace()) != null && ste.length > 0 && "loadBundleClass".equals(ste[0].getMethodName())) {
                    message = message + ": Class " + exception.getMessage() + " not found";
                    if (event.getBundle() != null) {
                        message = message + " in bundle " + event.getBundle().getSymbolicName() + " (" + event.getBundle().getBundleId() + ")";
                    }
                    level = 3;
                    exception = null;
                    break;
                }
                level = 1;
                break;
            }
            case 4: {
                message = "FrameworkEvent PACKAGES REFRESHED";
                break;
            }
            case 8: {
                message = "FrameworkEvent STARTLEVEL CHANGED";
                break;
            }
            case 16: {
                message = "FrameworkEvent WARNING";
                break;
            }
            case 32: {
                message = "FrameworkEvent INFO";
                break;
            }
            default: {
                message = "FrameworkEvent " + event.getType();
            }
        }
        String s = event.getBundle() == null ? null : "Bundle " + event.getBundle();
        s = s == null ? message : s + " " + message;
        LogEntryImpl entry = new LogEntryImpl(event.getBundle(), null, level, message, exception);
        this.fireLogEvent(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getLogger(Bundle bundle) {
        Logger log;
        Long bundleId = new Long(bundle == null ? 0L : bundle.getBundleId());
        Map<Long, Logger> map = this.loggers;
        synchronized (map) {
            log = this.loggers.get(bundleId);
        }
        if (log == null) {
            String name;
            if (bundle == null) {
                name = "system.bundle";
            } else {
                name = bundle.getSymbolicName();
                if (name == null) {
                    name = bundle.getLocation();
                }
                if (name == null) {
                    name = String.valueOf(bundle.getBundleId());
                }
            }
            log = LoggerFactory.getLogger((String)name);
            Map<Long, Logger> map2 = this.loggers;
            synchronized (map2) {
                this.loggers.put(bundleId, log);
            }
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetLogger(Bundle bundle) {
        Map<Long, Logger> map = this.loggers;
        synchronized (map) {
            this.loggers.remove(bundle.getBundleId());
        }
    }

    private void logOut(LogEntry logEntry) {
        Throwable exception;
        Logger log = this.getLogger(logEntry.getBundle());
        StringBuffer msg = new StringBuffer();
        ServiceReference sr = logEntry.getServiceReference();
        if (sr != null) {
            msg.append("Service [");
            if (sr.getProperty("service.pid") != null) {
                msg.append(sr.getProperty("service.pid")).append(',');
            } else if (sr.getProperty(COMPONENT_NAME) != null) {
                msg.append(sr.getProperty(COMPONENT_NAME)).append(',');
            } else if (sr.getProperty("service.description") != null) {
                msg.append(sr.getProperty("service.description")).append(',');
            }
            msg.append(sr.getProperty("service.id")).append("] ");
        }
        if (logEntry.getMessage() != null) {
            msg.append(logEntry.getMessage());
        }
        if ((exception = logEntry.getException()) != null) {
            msg.append(" (").append(exception).append(')');
        }
        String message = msg.toString();
        switch (logEntry.getLevel()) {
            case 4: {
                log.debug(message, exception);
                break;
            }
            case 3: {
                log.info(message, exception);
                break;
            }
            case 2: {
                log.warn(message, exception);
                break;
            }
            case 1: {
                log.error(message, exception);
                break;
            }
            default: {
                if (logEntry.getLevel() > 4) {
                    log.trace(message, exception);
                    break;
                }
                if (logEntry.getLevel() >= 1) break;
                log.error(message, exception);
            }
        }
    }

    private static class LogEntryDispatcher
    extends Thread {
        private final LogSupport logSupport;
        private final BlockingQueue<LogEntry> dispatchQueue;
        private boolean active;

        LogEntryDispatcher(LogSupport logSupport) {
            super("LogEntry Dispatcher");
            this.logSupport = logSupport;
            this.dispatchQueue = new LinkedBlockingQueue<LogEntry>();
            this.active = true;
        }

        void enqueLogEntry(LogEntry logEntry) {
            this.dispatchQueue.offer(logEntry);
        }

        LogEntry dequeueLogEntry() throws InterruptedException {
            return this.dispatchQueue.take();
        }

        void terminate() {
            this.active = false;
            this.interrupt();
        }

        public void run() {
            while (this.active) {
                LogListenerProxy[] logListeners;
                LogEntry logEntry = null;
                try {
                    logEntry = this.dequeueLogEntry();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (logEntry == null || (logListeners = this.logSupport.getListeners()) == null) continue;
                for (LogListenerProxy logListener : logListeners) {
                    try {
                        logListener.logged(logEntry);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class LogListenerProxy
    implements LogListener {
        private final int runningBundle = 56;
        private final Bundle bundle;
        private final LogListener delegatee;

        public LogListenerProxy(Bundle bundle, LogListener delegatee) {
            this.bundle = bundle;
            this.delegatee = delegatee;
        }

        public void logged(LogEntry entry) {
            if ((this.bundle.getState() & 0x38) != 0) {
                this.delegatee.logged(entry);
            }
        }

        boolean isSame(LogListener listener) {
            return listener == this.delegatee || listener == this;
        }

        boolean hasBundle(Bundle bundle) {
            return this.bundle == bundle;
        }
    }
}

