/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestUtil {
    public static Map<String, Map<String, String>> parserHeader(String value) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        String[] tokens = value.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            Map<String, String> parMap;
            String[] parameters = tokens[i].split(";");
            String name = parameters[0].trim();
            if (parameters.length > 0) {
                parMap = new HashMap();
                for (int j = 1; j < parameters.length; ++j) {
                    String[] content = parameters[j].split("=", 2);
                    if (content.length > 1) {
                        parMap.put(content[0].trim(), content[1].trim());
                        continue;
                    }
                    parMap.put(content[0].trim(), content[0].trim());
                }
            } else {
                parMap = Collections.emptyMap();
            }
            result.put(name, parMap);
        }
        return result;
    }

    public static Map<String, Double> parserAcceptHeader(String value) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        String[] tokens = value.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String[] parameters = tokens[i].split(";");
            String name = parameters[0];
            Double qVal = new Double(1.0);
            if (parameters.length > 1) {
                for (int j = 1; j < parameters.length; ++j) {
                    String[] content = parameters[j].split("=", 2);
                    if (content.length <= 1 || !"q".equals(content[0])) continue;
                    try {
                        qVal = Double.valueOf(content[1]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            if (qVal == null) continue;
            result.put(name, qVal);
        }
        return result;
    }

    public static String getServletName(Servlet servlet) {
        String name = null;
        if (servlet.getServletConfig() != null) {
            name = servlet.getServletConfig().getServletName();
        }
        if (name == null || name.length() == 0) {
            name = servlet.getServletInfo();
        }
        if (name == null || name.length() == 0) {
            name = servlet.getClass().getName();
        }
        return name;
    }

    public static Object setRequestAttribute(HttpServletRequest request, String name, Object value) {
        Object oldValue = request.getAttribute(name);
        if (value == null) {
            request.removeAttribute(name);
        } else {
            request.setAttribute(name, value);
        }
        return oldValue;
    }
}

