/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.RequestUtil;
import org.apache.sling.engine.auth.AuthenticationHandler;
import org.apache.sling.engine.auth.AuthenticationInfo;
import org.apache.sling.engine.auth.Authenticator;
import org.apache.sling.engine.auth.NoAuthenticationHandlerException;
import org.apache.sling.engine.impl.auth.MissingRepositoryException;
import org.apache.sling.jcr.api.TooManySessionsException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingAuthenticator
implements ManagedService,
Authenticator {
    public static final String REQUEST_ATTRIBUTE_HANDLER = "org.apache.sling.engine.impl.auth.authentication_handler";
    private static final Logger log = LoggerFactory.getLogger(SlingAuthenticator.class);
    public static final String PAR_IMPERSONATION_COOKIE_NAME = "auth.sudo.cookie";
    public static final String PAR_IMPERSONATION_PAR_NAME = "auth.sudo.parameter";
    public static final String PAR_ANONYMOUS_ALLOWED = "auth.annonymous";
    private static final String DEFAULT_IMPERSONATION_PARAMETER = "sudo";
    private static final String DEFAULT_IMPERSONATION_COOKIE = "sling.sudo";
    private static final boolean DEFAULT_ANONYMOUS_ALLOWED = true;
    private final ServiceTracker repositoryTracker;
    private final ServiceTracker authHandlerTracker;
    private int authHandlerTrackerCount;
    private Map<String, Map<String, AuthenticationHandlerInfo[]>> authHandlerCache;
    private String sudoParameterName;
    private String sudoCookieName;
    private boolean cacheControl;
    boolean anonymousAllowed;
    private ServiceRegistration registration;
    private static Map<String, Map<String, AuthenticationHandlerInfo[]>> EMPTY_PROTOCOL_MAP = new HashMap<String, Map<String, AuthenticationHandlerInfo[]>>();
    private static AuthenticationHandlerInfo[] EMPTY_INFO = new AuthenticationHandlerInfo[0];

    public SlingAuthenticator(BundleContext bundleContext) {
        this.repositoryTracker = new ServiceTracker(bundleContext, Repository.class.getName(), null);
        this.repositoryTracker.open();
        this.authHandlerTracker = new ServiceTracker(bundleContext, AuthenticationHandler.class.getName(), null);
        this.authHandlerTracker.open();
        this.authHandlerTrackerCount = -1;
        this.authHandlerCache = null;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", this.getClass().getName());
        ((Dictionary)props).put("service.description", "Sling Request Authenticator");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.registration = bundleContext.registerService(new String[]{ManagedService.class.getName(), Authenticator.class.getName()}, (Object)this, props);
    }

    public void dispose() {
        this.registration.unregister();
        this.authHandlerTracker.close();
        this.repositoryTracker.close();
    }

    public boolean authenticate(HttpServletRequest req, HttpServletResponse res) throws MissingRepositoryException {
        AuthenticationInfo authInfo;
        Object sessionAttr = req.getAttribute("javax.jcr.Session");
        if (sessionAttr instanceof Session) {
            log.debug("authenticate: Request already authenticated, nothing to do");
            return true;
        }
        if (sessionAttr != null) {
            log.warn("authenticate: Overwriting existing Session attribute ({})", sessionAttr);
            req.removeAttribute("javax.jcr.Session");
        }
        if ((authInfo = this.getAuthenticationInfo(req, res)) == AuthenticationInfo.DOING_AUTH) {
            log.debug("authenticate: ongoing authentication in the handler");
            return false;
        }
        if (authInfo == null) {
            log.debug("authenticate: no credentials in the request, anonymous");
            return this.getAnonymousSession(req, res);
        }
        try {
            log.debug("authenticate: credentials, trying to get a session");
            Session session = this.getRepository().login(authInfo.getCredentials(), authInfo.getWorkspaceName());
            session = this.handleImpersonation(req, res, session);
            this.setAttributes(session, authInfo.getAuthType(), req);
            return true;
        }
        catch (RepositoryException re) {
            this.handleLoginFailure(req, res, (Exception)((Object)re));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void login(HttpServletRequest request, HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        AuthenticationHandlerInfo[] handlerInfos = this.findApplicableAuthenticationHandlers(request);
        boolean done = false;
        for (int i = 0; !done && i < handlerInfos.length; ++i) {
            if (!request.getPathInfo().startsWith(handlerInfos[i].path)) continue;
            log.debug("requestAuthentication: requesting authentication using handler: {}", (Object)handlerInfos[i]);
            Object oldPathAttr = RequestUtil.setRequestAttribute(request, "path", handlerInfos[i].fullPath);
            try {
                done = handlerInfos[i].handler.requestAuthentication(request, response);
                continue;
            }
            catch (IOException ioe) {
                log.error("requestAuthentication: Failed sending authentication request through handler " + handlerInfos[i] + ", access forbidden", (Throwable)ioe);
                done = true;
                continue;
            }
            finally {
                RequestUtil.setRequestAttribute(request, "path", oldPathAttr);
            }
        }
        if (!done) {
            log.info("requestAuthentication: No handler for request ({} handlers available)", (Object)handlerInfos.length);
            throw new NoAuthenticationHandlerException();
        }
    }

    public void updated(Dictionary properties) {
        Object flag;
        String newPar;
        String newCookie;
        if (properties == null) {
            properties = new Hashtable();
        }
        if ((newCookie = (String)((Dictionary)properties).get(PAR_IMPERSONATION_COOKIE_NAME)) == null || newCookie.length() == 0) {
            newCookie = DEFAULT_IMPERSONATION_COOKIE;
        }
        if (!newCookie.equals(this.sudoCookieName)) {
            log.info("Setting new cookie name for impersonation {} (was {})", (Object)newCookie, (Object)this.sudoCookieName);
            this.sudoCookieName = newCookie;
        }
        if ((newPar = (String)((Dictionary)properties).get(PAR_IMPERSONATION_PAR_NAME)) == null || newPar.length() == 0) {
            newPar = DEFAULT_IMPERSONATION_PARAMETER;
        }
        if (!newPar.equals(this.sudoParameterName)) {
            log.info("Setting new parameter name for impersonation {} (was {})", (Object)newPar, (Object)this.sudoParameterName);
            this.sudoParameterName = newPar;
        }
        this.anonymousAllowed = (flag = ((Dictionary)properties).get(PAR_ANONYMOUS_ALLOWED)) instanceof Boolean ? (Boolean)flag : true;
    }

    private Repository getRepository() throws MissingRepositoryException {
        Repository repo = (Repository)this.repositoryTracker.getService();
        if (repo == null) {
            throw new MissingRepositoryException("No Repository available to " + this.getClass().getSimpleName() + ", cannot authenticate");
        }
        return repo;
    }

    private AuthenticationHandlerInfo[] findApplicableAuthenticationHandlers(HttpServletRequest request) {
        Map<String, Map<String, AuthenticationHandlerInfo[]>> byProtocolMap = this.getAuthenticationHandlers();
        Map<String, AuthenticationHandlerInfo[]> byHostMap = byProtocolMap.get(request.getScheme());
        if (byHostMap == null) {
            byHostMap = byProtocolMap.get("");
        }
        String hostname = request.getServerName() + (request.getServerPort() != 80 && request.getServerPort() != 443 ? ":" + request.getServerPort() : "");
        AuthenticationHandlerInfo[] infos = null;
        if (byHostMap != null) {
            infos = byHostMap.get(hostname);
            if (infos == null) {
                infos = byHostMap.get("");
            }
            if (infos != null) {
                return infos;
            }
        }
        return EMPTY_INFO;
    }

    private Map<String, Map<String, AuthenticationHandlerInfo[]>> getAuthenticationHandlers() {
        if (this.authHandlerCache == null || this.authHandlerTrackerCount < this.authHandlerTracker.getTrackingCount()) {
            ServiceReference[] services = this.authHandlerTracker.getServiceReferences();
            if (services == null || services.length == 0) {
                this.authHandlerCache = EMPTY_PROTOCOL_MAP;
            } else {
                HashMap byProtocolMap = new HashMap();
                int regPathCount = 0;
                for (int i = 0; i < services.length; ++i) {
                    String[] paths = OsgiUtil.toStringArray((Object)services[i].getProperty("path"));
                    if (paths == null || paths.length <= 0) continue;
                    AuthenticationHandler handler = (AuthenticationHandler)this.authHandlerTracker.getService(services[i]);
                    for (int m = 0; m < paths.length; ++m) {
                        ArrayList<AuthenticationHandlerInfo> byPathList;
                        String fullPath;
                        if (paths[m] == null || paths[m].length() <= 0) continue;
                        String path = fullPath = paths[m];
                        String host = "";
                        String protocol = "";
                        if (path.startsWith("http://") || path.startsWith("https://")) {
                            int idxProtocolEnd = path.indexOf("://");
                            protocol = path.substring(0, idxProtocolEnd);
                            path = path.substring(idxProtocolEnd + 1);
                        }
                        if (path.startsWith("//")) {
                            int idxHostEnd = path.indexOf("/", 2);
                            int n = idxHostEnd = idxHostEnd == -1 ? path.length() : idxHostEnd;
                            if (path.length() > 2) {
                                host = path.substring(2, idxHostEnd);
                                path = idxHostEnd < path.length() ? path.substring(idxHostEnd) : "/";
                            } else {
                                path = "/";
                            }
                        }
                        AuthenticationHandlerInfo newInfo = new AuthenticationHandlerInfo(fullPath, path, host, protocol, handler);
                        HashMap<String, ArrayList<AuthenticationHandlerInfo>> byHostMap = (HashMap<String, ArrayList<AuthenticationHandlerInfo>>)byProtocolMap.get(protocol);
                        if (byHostMap == null) {
                            byHostMap = new HashMap<String, ArrayList<AuthenticationHandlerInfo>>();
                            byProtocolMap.put(protocol, byHostMap);
                        }
                        if ((byPathList = (ArrayList<AuthenticationHandlerInfo>)byHostMap.get(host)) == null) {
                            byPathList = new ArrayList<AuthenticationHandlerInfo>();
                            byHostMap.put(host, byPathList);
                        }
                        byPathList.add(newInfo);
                        ++regPathCount;
                    }
                }
                if (regPathCount == 0) {
                    this.authHandlerCache = EMPTY_PROTOCOL_MAP;
                } else {
                    this.authHandlerCache = new HashMap<String, Map<String, AuthenticationHandlerInfo[]>>();
                    for (Map.Entry protocolEntry : byProtocolMap.entrySet()) {
                        Map hostMap = (Map)protocolEntry.getValue();
                        Map<String, AuthenticationHandlerInfo[]> finalHostMap = this.authHandlerCache.get(protocolEntry.getKey());
                        if (finalHostMap == null) {
                            finalHostMap = new HashMap<String, AuthenticationHandlerInfo[]>();
                            this.authHandlerCache.put((String)protocolEntry.getKey(), finalHostMap);
                        }
                        for (Map.Entry hostEntry : hostMap.entrySet()) {
                            List pathList = (List)hostEntry.getValue();
                            Collections.sort(pathList, AuthenticationHandlerInfoComparator.SINGLETON);
                            AuthenticationHandlerInfo[] authInfos = pathList.toArray(new AuthenticationHandlerInfo[pathList.size()]);
                            finalHostMap.put((String)hostEntry.getKey(), authInfos);
                        }
                    }
                }
            }
            this.authHandlerTrackerCount = this.authHandlerTracker.getTrackingCount();
        }
        return this.authHandlerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationInfo getAuthenticationInfo(HttpServletRequest request, HttpServletResponse response) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.length() == 0) {
            pathInfo = "/";
        }
        AuthenticationHandlerInfo[] local = this.findApplicableAuthenticationHandlers(request);
        for (int i = 0; i < local.length; ++i) {
            if (!pathInfo.startsWith(local[i].path)) continue;
            Object oldPathAttr = RequestUtil.setRequestAttribute(request, "path", local[i].fullPath);
            try {
                AuthenticationInfo authInfo = local[i].handler.authenticate(request, response);
                if (authInfo == null) continue;
                AuthenticationInfo authenticationInfo = authInfo;
                return authenticationInfo;
            }
            finally {
                RequestUtil.setRequestAttribute(request, "path", oldPathAttr);
            }
        }
        log.debug("getCredentials: no handler could extract credentials");
        return null;
    }

    private boolean getAnonymousSession(HttpServletRequest req, HttpServletResponse res) throws MissingRepositoryException {
        boolean isLoginPath = "/system/sling/login".equals(req.getPathInfo());
        if (this.anonymousAllowed || isLoginPath) {
            try {
                Session session = this.getRepository().login();
                this.setAttributes(session, null, req);
                return true;
            }
            catch (RepositoryException re) {
                this.handleLoginFailure(req, res, (Exception)((Object)re));
                return false;
            }
        }
        log.info("getAnonymousSession: Anonymous access not allowed by configuration - redirecting to login");
        this.login(req, res);
        return false;
    }

    private void handleLoginFailure(HttpServletRequest request, HttpServletResponse response, Exception reason) {
        if (reason instanceof TooManySessionsException) {
            log.info("authenticate: Too many sessions for user: {}", (Object)reason.getMessage());
            try {
                response.sendError(503, "SlingAuthenticator: Too Many Users");
            }
            catch (IOException ioe) {
                log.error("authenticate: Cannot send status 503 to client", (Throwable)ioe);
            }
        } else if (reason instanceof LoginException) {
            log.info("authenticate: Unable to authenticate: {}", (Object)reason.getMessage());
            this.login(request, response);
        } else {
            log.error("authenticate: Unable to authenticate", (Throwable)reason);
            try {
                response.sendError(500, "SlingAuthenticator: data access error, reason=" + reason.getClass().getSimpleName());
            }
            catch (IOException ioe) {
                log.error("authenticate: Cannot send status 500 to client", (Throwable)ioe);
            }
        }
    }

    private void setAttributes(Session session, String authType, HttpServletRequest request) {
        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)session.getUserID());
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)authType);
        request.setAttribute("javax.jcr.Session", (Object)session);
        log.debug("Session stored as request attribute: user={}, workspace={}", (Object)session.getUserID(), (Object)session.getWorkspace().getName());
    }

    private void sendCookie(HttpServletResponse response, String name, String value, int maxAge, String path) {
        if (path == null || path.length() == 0) {
            log.debug("sendCookie: Using root path ''/''");
            path = "/";
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        response.addCookie(cookie);
        if (this.cacheControl) {
            response.addHeader("Cache-Control", "no-cache=\"Set-Cookie\"");
        }
    }

    private Session handleImpersonation(HttpServletRequest req, HttpServletResponse res, Session session) throws LoginException, RepositoryException {
        String sudo;
        String currentSudo = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; currentSudo == null && i < cookies.length; ++i) {
                if (!this.sudoCookieName.equals(cookies[i].getName())) continue;
                currentSudo = cookies[i].getValue();
            }
        }
        if ((sudo = req.getParameter(this.sudoParameterName)) == null || sudo.length() == 0) {
            sudo = currentSudo;
        } else if ("-".equals(sudo)) {
            sudo = null;
        }
        if (sudo != null && sudo.length() > 0) {
            SimpleCredentials creds = new SimpleCredentials(sudo, new char[0]);
            session = session.impersonate((Credentials)creds);
        }
        if (sudo != currentSudo) {
            if (sudo == null) {
                this.sendCookie(res, this.sudoCookieName, "", 0, req.getContextPath());
            } else if (currentSudo == null || !currentSudo.equals(sudo)) {
                this.sendCookie(res, this.sudoCookieName, sudo, -1, req.getContextPath());
            }
        }
        return session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class AuthenticationHandlerInfoComparator
    implements Comparator<AuthenticationHandlerInfo> {
        public static final AuthenticationHandlerInfoComparator SINGLETON = new AuthenticationHandlerInfoComparator();

        protected AuthenticationHandlerInfoComparator() {
        }

        @Override
        public int compare(AuthenticationHandlerInfo arg0, AuthenticationHandlerInfo arg1) {
            return arg0.path.compareTo(arg1.path) * -1;
        }
    }

    protected static final class AuthenticationHandlerInfo {
        public final String fullPath;
        public final String path;
        public final String host;
        public final String protocol;
        public final AuthenticationHandler handler;

        public AuthenticationHandlerInfo(String fullPath, String p, String host, String protocol, AuthenticationHandler h) {
            this.fullPath = fullPath;
            this.path = p;
            this.host = host;
            this.protocol = protocol;
            this.handler = h;
        }
    }
}

