/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterMap
extends HashMap<String, RequestParameter[]>
implements RequestParameterMap {
    private Map<String, String[]> stringParameterMap;

    ParameterMap() {
    }

    public RequestParameter getValue(String name) {
        RequestParameter[] params = this.getValues(name);
        return params != null && params.length > 0 ? params[0] : null;
    }

    public RequestParameter[] getValues(String name) {
        return (RequestParameter[])super.get(name);
    }

    void renameParameter(String oldName, String newName) {
        RequestParameter[] params = (RequestParameter[])super.remove(oldName);
        super.put(newName, params);
    }

    void addParameter(String name, RequestParameter parameter) {
        Object current = this.get(name);
        if (current == null) {
            super.put(name, new RequestParameter[]{parameter});
        } else {
            RequestParameter[] ppo = (RequestParameter[])current;
            RequestParameter[] ppn = new RequestParameter[ppo.length + 1];
            System.arraycopy(ppo, 0, ppn, 0, ppo.length);
            ppn[ppo.length] = parameter;
            super.put(name, ppn);
        }
    }

    void setParameters(String name, RequestParameter[] parameters) {
        super.put(name, parameters);
    }

    Map<String, String[]> getStringParameterMap() {
        if (this.stringParameterMap == null) {
            HashMap pm = new HashMap();
            for (Map.Entry ppmEntry : this.entrySet()) {
                RequestParameter[] pps = (RequestParameter[])ppmEntry.getValue();
                String[] ps = new String[pps.length];
                for (int i = 0; i < pps.length; ++i) {
                    ps[i] = pps[i].getString();
                }
                pm.put(ppmEntry.getKey(), ps);
            }
            this.stringParameterMap = Collections.unmodifiableMap(pm);
        }
        return this.stringParameterMap;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public RequestParameter[] put(String key, RequestParameter[] value) {
        throw new UnsupportedOperationException("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends RequestParameter[]> t) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public RequestParameter[] remove(Object key) {
        throw new UnsupportedOperationException("remove");
    }
}

