/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;

public class SlingRequestPathInfo
implements RequestPathInfo {
    private final String selectorString;
    private final String[] selectors;
    private final String extension;
    private final String suffix;
    private final String resourcePath;
    private static final String[] NO_SELECTORS = new String[0];

    public SlingRequestPathInfo(Resource r) {
        String pathToSplit;
        int firstSlash;
        if (r == null) {
            throw new NullPointerException("resource");
        }
        this.resourcePath = r.getResourceMetadata().getResolutionPath();
        String pathToParse = r.getResourceMetadata().getResolutionPathInfo();
        if (pathToParse == null) {
            pathToParse = "";
        }
        if ((firstSlash = pathToParse.indexOf(47)) < 0) {
            pathToSplit = pathToParse;
            this.suffix = null;
        } else {
            pathToSplit = pathToParse.substring(0, firstSlash);
            this.suffix = pathToParse.substring(firstSlash);
        }
        int lastDot = pathToSplit.lastIndexOf(46);
        if (lastDot <= 1) {
            this.selectorString = null;
            this.selectors = NO_SELECTORS;
        } else {
            String tmpSel = pathToSplit.substring(1, lastDot);
            this.selectors = tmpSel.split("\\.");
            this.selectorString = this.selectors.length > 0 ? tmpSel : null;
        }
        this.extension = lastDot + 1 < pathToSplit.length() ? pathToSplit.substring(lastDot + 1) : null;
    }

    private SlingRequestPathInfo(String resourcePath, String selectorString, String extension, String suffix) {
        this.resourcePath = resourcePath;
        this.selectorString = selectorString;
        this.selectors = selectorString != null ? selectorString.split("\\.") : NO_SELECTORS;
        this.extension = extension;
        this.suffix = suffix;
    }

    public SlingRequestPathInfo merge(RequestPathInfo baseInfo) {
        if (this.getExtension() == null) {
            return new SlingRequestPathInfo(this.getResourcePath(), baseInfo.getSelectorString(), baseInfo.getExtension(), baseInfo.getSuffix());
        }
        return this;
    }

    public SlingRequestPathInfo merge(RequestDispatcherOptions options) {
        if (options != null) {
            String suffix;
            boolean needCreate = false;
            String selectors = options.getReplaceSelectors();
            if (selectors != null) {
                needCreate = true;
            } else {
                selectors = this.getSelectorString();
            }
            String selectorsAdd = options.getAddSelectors();
            if (selectorsAdd != null) {
                selectors = selectors != null ? selectors + "." + selectorsAdd : selectorsAdd;
                needCreate = true;
            }
            if ((suffix = options.getReplaceSuffix()) != null) {
                needCreate = true;
            } else {
                suffix = this.getSuffix();
            }
            if (needCreate) {
                return new SlingRequestPathInfo(this.getResourcePath(), selectors, this.getExtension(), suffix);
            }
        }
        return this;
    }

    public String toString() {
        return "SlingRequestPathInfo: path='" + this.resourcePath + "'" + ", selectorString='" + this.selectorString + "'" + ", extension='" + this.extension + "'" + ", suffix='" + this.suffix + "'";
    }

    public String getExtension() {
        return this.extension;
    }

    public String[] getSelectors() {
        return this.selectors;
    }

    public String getSelectorString() {
        return this.selectorString;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }
}

