/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.request.RequestProgressTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingRequestProgressTracker
implements RequestProgressTracker {
    private static final String DUMP_FORMAT = "%1$7d (%2$tF %2$tT) %3$s%n";
    private static final String REQUEST_PROCESSING_TIMER = "Request Processing";
    private static final String LOG_PREFIX = "LOG ";
    private static final String COMMENT_PREFIX = "COMMENT ";
    private static final String TIMER_END_FORMAT = "{<elapsed msec>,<timer name>} <optional message>";
    private long processingStart;
    private final List<TrackingEntry> entries = new ArrayList<TrackingEntry>();
    private final Map<String, Long> namedTimerEntries = new HashMap<String, Long>();
    private boolean done;

    public SlingRequestProgressTracker() {
        this.reset();
    }

    public void reset() {
        this.done = false;
        this.entries.clear();
        this.namedTimerEntries.clear();
        this.processingStart = this.startTimerInternal(REQUEST_PROCESSING_TIMER);
        this.entries.add(new TrackingEntry("COMMENT timer_end format is {<elapsed msec>,<timer name>} <optional message>"));
    }

    public Iterator<String> getMessages() {
        return new Iterator<String>(){
            private final Iterator<TrackingEntry> entryIter;
            {
                this.entryIter = SlingRequestProgressTracker.this.entries.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIter.hasNext();
            }

            @Override
            public String next() {
                TrackingEntry entry = this.entryIter.next();
                long offset = entry.getTimeStamp() - SlingRequestProgressTracker.this.processingStart;
                return String.format(SlingRequestProgressTracker.DUMP_FORMAT, offset, entry.getTimeStamp(), entry.getMessage());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public void dump(PrintWriter writer) {
        this.logTimer(REQUEST_PROCESSING_TIMER, "Dumping SlingRequestProgressTracker Entries", new Object[0]);
        Iterator<String> messages = this.getMessages();
        while (messages.hasNext()) {
            writer.print(messages.next());
        }
    }

    public void log(String message) {
        this.entries.add(new TrackingEntry(LOG_PREFIX + message));
    }

    public void log(String format, Object ... args) {
        String message = MessageFormat.format(format, args);
        this.entries.add(new TrackingEntry(LOG_PREFIX + message));
    }

    private void log(long timeStamp, String message) {
        this.entries.add(new TrackingEntry(timeStamp, message));
    }

    public void startTimer(String name) {
        this.startTimerInternal(name);
    }

    private long startTimerInternal(String name) {
        long timer = System.currentTimeMillis();
        this.namedTimerEntries.put(name, timer);
        this.entries.add(new TrackingEntry(timer, "TIMER_START{" + name + "}"));
        return timer;
    }

    public void logTimer(String name) {
        if (this.namedTimerEntries.containsKey(name)) {
            this.logTimerInternal(name, null, this.namedTimerEntries.get(name));
        }
    }

    public void logTimer(String name, String format, Object ... args) {
        if (this.namedTimerEntries.containsKey(name)) {
            this.logTimerInternal(name, MessageFormat.format(format, args), this.namedTimerEntries.get(name));
        }
    }

    private void logTimerInternal(String name, String msg, long startTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("TIMER_END{");
        sb.append(System.currentTimeMillis() - startTime);
        sb.append(',');
        sb.append(name);
        sb.append('}');
        if (msg != null) {
            sb.append(' ');
            sb.append(msg);
        }
        this.entries.add(new TrackingEntry(sb.toString()));
    }

    public void done() {
        if (this.done) {
            return;
        }
        this.logTimer(REQUEST_PROCESSING_TIMER, REQUEST_PROCESSING_TIMER, new Object[0]);
        this.done = true;
    }

    private static class TrackingEntry {
        private final long timeStamp;
        private final String message;

        TrackingEntry(String message) {
            this.timeStamp = System.currentTimeMillis();
            this.message = message;
        }

        TrackingEntry(long timeStamp, String message) {
            this.timeStamp = timeStamp;
            this.message = message;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        String getMessage() {
            return this.message;
        }
    }
}

