/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RequestHistoryConsolePlugin {
    public static final String LABEL = "requests";
    public static final String INDEX = "index";
    public static final String CLEAR = "clear";
    private static Plugin instance;
    public static final int STORED_REQUESTS_COUNT = 20;

    private RequestHistoryConsolePlugin() {
    }

    public static void recordRequest(SlingHttpServletRequest r) {
        if (instance != null) {
            RequestHistoryConsolePlugin.instance.addRequest(r);
        }
    }

    public static void initPlugin(BundleContext context) {
        if (instance == null) {
            Plugin tmp = new Plugin();
            tmp.activate(context);
            instance = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyPlugin() {
        if (instance != null) {
            try {
                instance.deactivate();
            }
            finally {
                instance = null;
            }
        }
    }

    public static final class Plugin
    extends AbstractWebConsolePlugin {
        private final SlingHttpServletRequest[] requests = new SlingHttpServletRequest[20];
        private final String[] methods = new String[20];
        private ServiceRegistration serviceRegistration;
        private int lastRequestIndex = -1;

        private synchronized void addRequest(SlingHttpServletRequest r) {
            int index = this.lastRequestIndex + 1;
            if (index >= this.requests.length) {
                index = 0;
            }
            this.requests[index] = r;
            this.methods[index] = r.getMethod();
            this.lastRequestIndex = index;
        }

        private synchronized void clear() {
            for (int i = 0; i < this.requests.length; ++i) {
                this.requests[i] = null;
            }
            this.lastRequestIndex = -1;
        }

        public void activate(BundleContext context) {
            super.activate(context);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Web Console Plugin to display information about recent Sling requests");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
            ((Dictionary)props).put("felix.webconsole.label", RequestHistoryConsolePlugin.LABEL);
            this.serviceRegistration = context.registerService("javax.servlet.Servlet", (Object)this, props);
        }

        public void deactivate() {
            if (this.serviceRegistration != null) {
                this.serviceRegistration.unregister();
                this.serviceRegistration = null;
            }
            super.deactivate();
        }

        public String getLabel() {
            return RequestHistoryConsolePlugin.LABEL;
        }

        public String getTitle() {
            return "Recent requests";
        }

        private int getArrayIndex(int displayIndex) {
            int result = this.lastRequestIndex - displayIndex;
            if (result < 0) {
                result += this.requests.length;
            }
            return result;
        }

        private String getLinksTable(int currentRequestIndex) {
            ArrayList<String> links = new ArrayList<String>();
            for (int i = 0; i < this.requests.length; ++i) {
                StringBuilder sb = new StringBuilder();
                if (this.requests[i] == null) continue;
                sb.append("<a href='requests?index=" + i + "'>");
                if (i == currentRequestIndex) {
                    sb.append("<b>");
                }
                sb.append(this.getRequestLabel(this.getArrayIndex(i)));
                if (i == currentRequestIndex) {
                    sb.append("</b>");
                }
                sb.append("</a> ");
                links.add(sb.toString());
            }
            int nCols = 5;
            while (links.size() % 5 != 0) {
                links.add("&nbsp;");
            }
            StringBuilder tbl = new StringBuilder();
            tbl.append("<table>\n<tr>\n");
            int i = 0;
            for (String str : links) {
                if (i++ % 5 == 0) {
                    tbl.append("</tr>\n<tr>\n");
                }
                tbl.append("<td>");
                tbl.append(str);
                tbl.append("</td>\n");
            }
            tbl.append("</tr>\n");
            tbl.append("</table>\n");
            return tbl.toString();
        }

        protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            if (req.getParameter(RequestHistoryConsolePlugin.CLEAR) != null) {
                this.clear();
                res.sendRedirect(RequestHistoryConsolePlugin.LABEL);
                return;
            }
            int index = 0;
            String tmp = req.getParameter(RequestHistoryConsolePlugin.INDEX);
            if (tmp != null) {
                try {
                    index = Integer.parseInt(tmp);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            int arrayIndex = this.getArrayIndex(index);
            SlingHttpServletRequest r = null;
            try {
                r = this.requests[arrayIndex];
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            PrintWriter pw = res.getWriter();
            pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
            pw.println("<thead>");
            pw.println("<tr class='content'>");
            pw.println("<th colspan='2'class='content container'>Recent Requests");
            pw.println(" (<a href='requests?clear=clear'>Clear</a>)");
            pw.println("</th>");
            pw.println("</thead>");
            pw.println("<tbody>");
            pw.println("<tr class='content'><td>");
            pw.println(this.getLinksTable(index));
            pw.println("</td></tr>");
            if (r != null) {
                pw.println("<tr class='content'>");
                pw.println("<th colspan='2'class='content container'>");
                pw.print("Request " + index + " (" + this.getRequestLabel(index) + ") - RequestProgressTracker Info");
                pw.println("</th></tr>");
                pw.println("<tr><td colspan='2'>");
                Iterator it = r.getRequestProgressTracker().getMessages();
                pw.print("<pre>");
                while (it.hasNext()) {
                    pw.print(Plugin.escape((String)it.next()));
                }
                pw.println("</pre></td></tr>");
            }
            pw.println("</tbody></table>");
        }

        private static String escape(String str) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }

        private String getRequestLabel(int index) {
            StringBuilder sb = new StringBuilder();
            String path = this.requests[index].getPathInfo();
            if (path == null) {
                path = "";
            }
            sb.append(this.methods[index]);
            sb.append(' ');
            int pos = this.requests[index].getPathInfo().lastIndexOf(47);
            if (pos < 0) {
                sb.append(this.requests[index].getPathInfo());
            } else {
                sb.append(this.requests[index].getPathInfo().substring(pos + 1));
            }
            return sb.toString();
        }
    }
}

