/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.engine.RequestLog;

class FileRequestLog
implements RequestLog {
    private static File relPathRoot;
    private static Map<String, PrintWriter> logFiles;
    private PrintWriter output;

    static void init(String relPathRoot) {
        FileRequestLog.relPathRoot = new File(relPathRoot).getAbsoluteFile();
    }

    static void dispose() {
        for (PrintWriter w : logFiles.values()) {
            try {
                ((Writer)w).close();
            }
            catch (IOException iOException) {}
        }
        logFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileRequestLog(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(relPathRoot, fileName);
        }
        fileName = file.getAbsolutePath();
        Map<String, PrintWriter> map = logFiles;
        synchronized (map) {
            this.output = logFiles.get(fileName);
            if (this.output == null) {
                file.getParentFile().mkdirs();
                FileWriter fw = new FileWriter(file, true);
                this.output = new PrintWriter(fw);
                logFiles.put(fileName, this.output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String message) {
        PrintWriter writer = this.output;
        if (writer != null) {
            PrintWriter printWriter = writer;
            synchronized (printWriter) {
                writer.println(message);
                writer.flush();
            }
        }
    }

    public void close() {
        this.output = null;
    }

    static {
        logFiles = new HashMap<String, PrintWriter>();
    }
}

