/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.engine.RequestLog;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;
import org.apache.sling.engine.impl.log.CustomLogFormat;
import org.apache.sling.engine.impl.log.FileRequestLog;
import org.apache.sling.engine.impl.log.LoggerRequestLog;
import org.apache.sling.engine.impl.log.RequestLogServiceFacade;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestLoggerService {
    public static final String PARAM_FORMAT = "request.log.service.format";
    public static final String PARAM_OUTPUT = "request.log.service.output";
    public static final String PARAM_OUTPUT_TYPE = "request.log.service.outputtype";
    public static final String PARAM_ON_ENTRY = "request.log.service.onentry";
    private static final int OUTPUT_TYPE_LOGGER = 0;
    private static final int OUTPUT_TYPE_FILE = 1;
    private static final int OUTPUT_TYPE_CLASS = 2;
    private boolean onEntry;
    private CustomLogFormat logFormat;
    private RequestLog log;

    public RequestLoggerService() {
    }

    RequestLoggerService(BundleContext bundleContext, Dictionary<String, Object> configuration) {
        this.setup(bundleContext, configuration);
    }

    void setup(BundleContext bundleContext, Dictionary<String, Object> configuration) {
        Object output;
        Object onEntryObject = configuration.get(PARAM_ON_ENTRY);
        this.onEntry = onEntryObject instanceof Boolean ? (Boolean)onEntryObject : false;
        Object format = configuration.get(PARAM_FORMAT);
        if (format != null) {
            this.logFormat = new CustomLogFormat(format.toString());
        }
        if ((output = configuration.get(PARAM_OUTPUT)) != null) {
            Object outputTypeObject = configuration.get(PARAM_OUTPUT_TYPE);
            int outputType = outputTypeObject instanceof Number ? ((Number)outputTypeObject).intValue() : 0;
            this.log = this.getLog(bundleContext, output.toString(), outputType);
        }
    }

    void shutdown() {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        this.logFormat = null;
    }

    void log(SlingHttpServletRequest request, SlingHttpServletResponseImpl response) {
        if (this.log != null && this.logFormat != null) {
            this.log.write(this.logFormat.format(request, response));
        }
    }

    boolean isOnEntry() {
        return this.onEntry;
    }

    protected void activate(ComponentContext context) {
        this.setup(context.getBundleContext(), context.getProperties());
    }

    protected void deactivate(ComponentContext context) {
        this.shutdown();
    }

    private RequestLog getLog(BundleContext bundleContext, String output, int outputType) {
        switch (outputType) {
            case 1: {
                try {
                    return new FileRequestLog(output);
                }
                catch (IOException ioe) {
                    break;
                }
            }
            case 2: {
                if (bundleContext == null) break;
                return new RequestLogServiceFacade(bundleContext, output);
            }
            default: {
                return new LoggerRequestLog(output);
            }
        }
        return null;
    }
}

