/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.request.RequestData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingHttpServletResponseImpl
extends HttpServletResponseWrapper
implements SlingHttpServletResponse {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final SimpleDateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static int requestCounter = 0;
    private int requestId;
    private long requestStart;
    private long requestEnd;
    private LoggerResponseOutputStream out;
    private LoggerResponseWriter writer;
    private int status = 200;
    private Map<String, Cookie> cookies;
    private Map<String, Object> headers;
    private final RequestData requestData;

    public SlingHttpServletResponseImpl(RequestData requestData, HttpServletResponse response) {
        super(response);
        this.requestData = requestData;
        this.requestId = requestCounter++;
        this.requestStart = System.currentTimeMillis();
    }

    public void requestEnd() {
        this.requestEnd = System.currentTimeMillis();
    }

    protected final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return this.getRequestData().adaptTo((Object)this, type);
    }

    public Locale getLocale() {
        return this.getResponse().getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            ServletOutputStream sos = this.getRequestData().getBufferProvider().getOutputStream();
            this.out = new LoggerResponseOutputStream(sos);
        }
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            PrintWriter pw = this.getRequestData().getBufferProvider().getWriter();
            this.writer = new LoggerResponseWriter(pw);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.getResponse().isCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.getRequestData().getContentData().resetBuffer();
        this.getResponse().reset();
    }

    public void flushBuffer() throws IOException {
        this.getRequestData().getContentData().flushBuffer();
        this.getResponse().flushBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.getRequestData().getContentData().resetBuffer();
        this.getResponse().resetBuffer();
    }

    public void setBufferSize(int size) {
        this.getRequestData().getContentData().setBufferSize(size);
        this.getResponse().setBufferSize(size);
    }

    public int getBufferSize() {
        return this.getRequestData().getContentData().getBufferSize();
    }

    public String encodeURL(String url) {
        url = this.makeAbsolutePath(url);
        url = this.map(url);
        return super.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        url = this.makeAbsolutePath(url);
        url = this.map(url);
        return super.encodeRedirectURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(location);
        this.status = 302;
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkCommitted();
        this.status = status;
        SlingRequestProcessorImpl eh = this.getRequestData().getSlingRequestProcessor();
        eh.handleError(status, message, this.requestData.getSlingRequest(), this);
    }

    public void setStatus(int status, String message) {
        this.checkCommitted();
        this.status = status;
        super.setStatus(status, message);
    }

    public void setStatus(int status) {
        this.checkCommitted();
        this.status = status;
        super.setStatus(status);
    }

    public void addCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        this.cookies.put(cookie.getName(), cookie);
        super.addCookie(cookie);
    }

    public void addDateHeader(String name, long date) {
        this.registerHeader(name, SlingHttpServletResponseImpl.toDateString(date), true);
        super.addDateHeader(name, date);
    }

    public void addHeader(String name, String value) {
        this.registerHeader(name, value, true);
        super.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.registerHeader(name, String.valueOf(value), true);
        super.addIntHeader(name, value);
    }

    public void setContentLength(int len) {
        this.registerHeader(HEADER_CONTENT_LENGTH, String.valueOf(len), false);
        super.setContentLength(len);
    }

    public void setContentType(String type) {
        this.registerHeader(HEADER_CONTENT_TYPE, type, false);
        super.setContentType(type);
    }

    public void setCharacterEncoding(String charset) {
        if (this.writer == null) {
            super.setCharacterEncoding(charset);
        }
    }

    public void setDateHeader(String name, long date) {
        this.registerHeader(name, SlingHttpServletResponseImpl.toDateString(date), false);
        super.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.registerHeader(name, value, false);
        super.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.registerHeader(name, String.valueOf(value), false);
        this.setHeader(name, String.valueOf(value));
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public long getRequestStart() {
        return this.requestStart;
    }

    public long getRequestEnd() {
        return this.requestEnd;
    }

    public long getRequestDuration() {
        return this.requestEnd - this.requestStart;
    }

    public int getStatus() {
        return this.status;
    }

    public int getCount() {
        if (this.out != null) {
            return this.out.getCount();
        }
        if (this.writer != null) {
            return this.writer.getCount();
        }
        return 0;
    }

    public Cookie getCookie(String name) {
        return this.cookies != null ? this.cookies.get(name) : null;
    }

    public String getHeaders(String name) {
        Object header;
        name = name.toLowerCase();
        Object object = header = this.headers != null ? this.headers.get(name) : null;
        if (header == null) {
            return null;
        }
        if (header instanceof String) {
            return (String)header;
        }
        StringBuffer headerBuf = new StringBuffer();
        Iterator hi = ((List)header).iterator();
        while (hi.hasNext()) {
            if (headerBuf.length() > 0) {
                headerBuf.append(",");
            }
            headerBuf.append(hi.next());
        }
        return headerBuf.toString();
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed");
        }
    }

    private String makeAbsolutePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String base = this.getRequestData().getContentData().getResource().getPath();
        int lastSlash = base.lastIndexOf(47);
        path = lastSlash >= 0 ? base.substring(0, lastSlash + 1) + path : "/" + path;
        return path;
    }

    private String map(String url) {
        return this.getRequestData().getResourceResolver().map(url);
    }

    private void registerHeader(String name, String value, boolean add) {
        Object current;
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        name = name.toLowerCase();
        Object object = current = add ? this.headers.get(name) : null;
        if (current == null) {
            this.headers.put(name, value);
        } else if (current instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)current);
            list.add(value);
            this.headers.put(name, list);
        } else {
            ((List)current).add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDateString(long date) {
        SimpleDateFormat simpleDateFormat = RFC1123_FORMAT;
        synchronized (simpleDateFormat) {
            return RFC1123_FORMAT.format(new Date(date));
        }
    }

    private static class LoggerResponseWriter
    extends PrintWriter {
        private static final int LINE_SEPARATOR_LENGTH = System.getProperty("line.separator").length();
        private int count;

        LoggerResponseWriter(PrintWriter delegatee) {
            super(delegatee);
        }

        public int getCount() {
            return this.count;
        }

        public void write(int c) {
            super.write(c);
            ++this.count;
        }

        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            this.count += len;
        }

        public void write(String s, int off, int len) {
            super.write(s, off, len);
            this.count += len;
        }

        public void println() {
            super.println();
            this.count += LINE_SEPARATOR_LENGTH;
        }
    }

    private static class LoggerResponseOutputStream
    extends ServletOutputStream {
        private ServletOutputStream delegatee;
        private int count;

        LoggerResponseOutputStream(ServletOutputStream delegatee) {
            this.delegatee = delegatee;
        }

        public int getCount() {
            return this.count;
        }

        public void write(int b) throws IOException {
            this.delegatee.write(b);
            ++this.count;
        }

        public void write(byte[] b) throws IOException {
            this.delegatee.write(b);
            this.count += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegatee.write(b, off, len);
            this.count += len;
        }

        public void flush() throws IOException {
            this.delegatee.flush();
        }

        public void close() throws IOException {
            this.delegatee.close();
        }
    }
}

