/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.request.RequestData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingHttpServletResponseImpl
extends HttpServletResponseWrapper
implements SlingHttpServletResponse {
    private final RequestData requestData;

    public SlingHttpServletResponseImpl(RequestData requestData, HttpServletResponse response) {
        super(response);
        this.requestData = requestData;
    }

    protected final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return this.getRequestData().adaptTo((Object)this, type);
    }

    public String encodeURL(String url) {
        url = this.makeAbsolutePath(url);
        url = this.map(url);
        return super.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        url = this.makeAbsolutePath(url);
        url = this.map(url);
        return super.encodeRedirectURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkCommitted();
        SlingRequestProcessorImpl eh = this.getRequestData().getSlingRequestProcessor();
        eh.handleError(status, message, this.requestData.getSlingRequest(), this);
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed");
        }
    }

    private String makeAbsolutePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String base = this.getRequestData().getContentData().getResource().getPath();
        int lastSlash = base.lastIndexOf(47);
        path = lastSlash >= 0 ? base.substring(0, lastSlash + 1) + path : "/" + path;
        return path;
    }

    private String map(String url) {
        return this.getRequestData().getResourceResolver().map(url);
    }
}

