/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.engine.impl.parameters.AbstractRequestParameter;
import org.apache.sling.engine.impl.parameters.MultipartRequestParameter;
import org.apache.sling.engine.impl.parameters.SlingPart;
import org.apache.sling.engine.impl.parameters.Util;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMap
extends LinkedHashMap<String, RequestParameter[]>
implements RequestParameterMap {
    private static final long serialVersionUID = -3984737679401682171L;
    static final int DEFAULT_MAX_PARAMS = 10000;
    private static int maxParameters = 10000;
    private Map<String, String[]> stringParameterMap;
    private List<RequestParameter> requestParameters = new ArrayList<RequestParameter>();

    static void setMaxParameters(int maxParameters) {
        ParameterMap.maxParameters = maxParameters > 0 ? maxParameters : -1;
    }

    public RequestParameter getValue(String name) {
        RequestParameter[] params = this.getValues(name);
        return params != null && params.length > 0 ? params[0] : null;
    }

    public RequestParameter[] getValues(String name) {
        return (RequestParameter[])super.get(name);
    }

    void renameParameter(String oldName, String newName) {
        RequestParameter[] params;
        for (RequestParameter param : params = (RequestParameter[])super.remove(oldName)) {
            ((AbstractRequestParameter)param).setName(newName);
        }
        super.put(newName, params);
    }

    void addParameter(RequestParameter parameter, boolean prependNew) {
        if (this.requestParameters.size() == maxParameters) {
            LoggerFactory.getLogger(Util.class).warn("Too many name/value pairs, stopped processing after " + maxParameters + " entries");
            return;
        }
        String name = parameter.getName();
        RequestParameter[] current = (RequestParameter[])this.get(name);
        if (current == null) {
            super.put(name, new RequestParameter[]{parameter});
        } else {
            RequestParameter[] ppn = new RequestParameter[current.length + 1];
            System.arraycopy(current, 0, ppn, prependNew ? 1 : 0, current.length);
            ppn[prependNew ? 0 : current.length] = parameter;
            super.put(name, ppn);
        }
        this.requestParameters.add(parameter);
    }

    void setParameters(String name, RequestParameter[] parameters) {
        super.put(name, parameters);
    }

    public String getStringValue(String name) {
        RequestParameter param = this.getValue(name);
        return param != null ? param.getString() : null;
    }

    public String[] getStringValues(String name) {
        return ParameterMap.toStringArray(this.getValues(name));
    }

    public Map<String, String[]> getStringParameterMap() {
        if (this.stringParameterMap == null) {
            LinkedHashMap pm = new LinkedHashMap();
            for (Map.Entry ppmEntry : this.entrySet()) {
                pm.put(ppmEntry.getKey(), ParameterMap.toStringArray((RequestParameter[])ppmEntry.getValue()));
            }
            this.stringParameterMap = Collections.unmodifiableMap(pm);
        }
        return this.stringParameterMap;
    }

    public Object getPart(String name) {
        RequestParameter p = this.getValue(name);
        if (p instanceof MultipartRequestParameter) {
            return new SlingPart((MultipartRequestParameter)p);
        }
        return null;
    }

    public Collection<?> getParts() {
        ArrayList<SlingPart> parts = new ArrayList<SlingPart>(this.size());
        for (RequestParameter[] param : this.values()) {
            if (param.length < 1 || !(param[0] instanceof MultipartRequestParameter)) continue;
            parts.add(new SlingPart((MultipartRequestParameter)param[0]));
        }
        return parts;
    }

    public List<RequestParameter> getRequestParameterList() {
        return Collections.unmodifiableList(this.requestParameters);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public RequestParameter[] put(String key, RequestParameter[] value) {
        throw new UnsupportedOperationException("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends RequestParameter[]> t) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public RequestParameter[] remove(Object key) {
        throw new UnsupportedOperationException("remove");
    }

    private static String[] toStringArray(RequestParameter[] params) {
        if (params == null) {
            return null;
        }
        String[] ps = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            ps[i] = params[i].getString();
        }
        return ps;
    }
}

