/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.jmx.RequestProcessorMBean;

class RequestProcessorMBeanImpl
extends StandardMBean
implements RequestProcessorMBean {
    private volatile long n;
    private volatile long durationMsecMin;
    private volatile long durationMsecMax;
    private volatile double durationMsecSumX;
    private volatile double durationMsecSumX2;
    private volatile int servletCallCountMin;
    private volatile int servletCallCountMax;
    private volatile double servletCallCountSumX;
    private volatile double servletCallCountSumX2;
    private volatile int peakRecursionDepthMin;
    private volatile int peakRecursionDepthMax;
    private volatile double peakRecursionDepthSumX;
    private volatile double peakRecursionDepthSumX2;

    RequestProcessorMBeanImpl() throws NotCompliantMBeanException {
        super(RequestProcessorMBean.class);
        this.resetStatistics();
    }

    synchronized void addRequestData(RequestData data) {
        ++this.n;
        long duration = data.getElapsedTimeMsec();
        int servletCallCount = data.getServletCallCount();
        int peakRecursionDepth = data.getPeakRecusionDepth();
        if (duration < this.durationMsecMin) {
            this.durationMsecMin = duration;
        }
        if (duration > this.durationMsecMax) {
            this.durationMsecMax = duration;
        }
        this.durationMsecSumX += (double)duration;
        this.durationMsecSumX2 += (double)(duration * duration);
        if (servletCallCount < this.servletCallCountMin) {
            this.servletCallCountMin = servletCallCount;
        }
        if (servletCallCount > this.servletCallCountMax) {
            this.servletCallCountMax = servletCallCount;
        }
        this.servletCallCountSumX += (double)servletCallCount;
        this.servletCallCountSumX2 += (double)(servletCallCount * servletCallCount);
        if (peakRecursionDepth < this.peakRecursionDepthMin) {
            this.peakRecursionDepthMin = peakRecursionDepth;
        }
        if (peakRecursionDepth > this.peakRecursionDepthMax) {
            this.peakRecursionDepthMax = peakRecursionDepth;
        }
        this.peakRecursionDepthSumX += (double)peakRecursionDepth;
        this.peakRecursionDepthSumX2 += (double)(peakRecursionDepth * peakRecursionDepth);
    }

    public long getRequestsCount() {
        return this.n;
    }

    public long getMinRequestDurationMsec() {
        return this.durationMsecMin;
    }

    public long getMaxRequestDurationMsec() {
        return this.durationMsecMax;
    }

    public synchronized double getStandardDeviationDurationMsec() {
        if (this.n > 1L) {
            return Math.sqrt((this.durationMsecSumX2 - this.durationMsecSumX * this.durationMsecSumX / (double)this.n) / (double)(this.n - 1L));
        }
        return 0.0;
    }

    public synchronized double getMeanRequestDurationMsec() {
        if (this.n > 0L) {
            return this.durationMsecSumX / (double)this.n;
        }
        return 0.0;
    }

    public synchronized void resetStatistics() {
        this.durationMsecMin = Long.MAX_VALUE;
        this.durationMsecMax = 0L;
        this.servletCallCountMin = Integer.MAX_VALUE;
        this.servletCallCountMax = 0;
        this.peakRecursionDepthMin = Integer.MAX_VALUE;
        this.peakRecursionDepthMax = 0;
        this.durationMsecSumX = 0.0;
        this.durationMsecSumX2 = 0.0;
        this.peakRecursionDepthSumX = 0.0;
        this.peakRecursionDepthSumX2 = 0.0;
        this.servletCallCountSumX = 0.0;
        this.servletCallCountSumX2 = 0.0;
        this.n = 0L;
    }

    public int getMaxPeakRecursionDepth() {
        return this.peakRecursionDepthMax;
    }

    public int getMinPeakRecursionDepth() {
        return this.peakRecursionDepthMin;
    }

    public double getMeanPeakRecursionDepth() {
        if (this.n > 0L) {
            return this.peakRecursionDepthSumX / (double)this.n;
        }
        return 0.0;
    }

    public double getStandardDeviationPeakRecursionDepth() {
        if (this.n > 1L) {
            return Math.sqrt((this.peakRecursionDepthSumX2 - this.peakRecursionDepthSumX * this.peakRecursionDepthSumX / (double)this.n) / (double)(this.n - 1L));
        }
        return 0.0;
    }

    public int getMaxServletCallCount() {
        return this.servletCallCountMax;
    }

    public int getMinServletCallCount() {
        return this.servletCallCountMin;
    }

    public double getMeanServletCallCount() {
        if (this.n > 0L) {
            return this.servletCallCountSumX / (double)this.n;
        }
        return 0.0;
    }

    public double getStandardDeviationServletCallCount() {
        if (this.n > 1L) {
            return Math.sqrt((this.servletCallCountSumX2 - this.servletCallCountSumX * this.servletCallCountSumX / (double)this.n) / (double)(this.n - 1L));
        }
        return 0.0;
    }
}

