/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.request.RequestData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingHttpServletResponseImpl
extends HttpServletResponseWrapper
implements SlingHttpServletResponse {
    private final RequestData requestData;
    private final boolean firstSlingResponse;

    public SlingHttpServletResponseImpl(RequestData requestData, HttpServletResponse response) {
        super(response);
        this.requestData = requestData;
        boolean bl = this.firstSlingResponse = !(response instanceof SlingHttpServletResponse);
        if (this.firstSlingResponse && RequestData.getAdditionalResponseHeaders() != null) {
            for (StaticResponseHeader mapping : RequestData.getAdditionalResponseHeaders()) {
                response.addHeader(mapping.getResponseHeaderName(), mapping.getResponseHeaderValue());
            }
        }
    }

    protected final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return this.getRequestData().adaptTo((Object)this, type);
    }

    public String encodeURL(String url) {
        String path = this.removeContextPath(url);
        path = this.makeAbsolutePath(path);
        path = this.map(path);
        return super.encodeURL(path);
    }

    public String encodeRedirectURL(String url) {
        String path = this.removeContextPath(url);
        path = this.makeAbsolutePath(path);
        path = this.map(path);
        return super.encodeRedirectURL(path);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkCommitted();
        SlingRequestProcessorImpl eh = this.getRequestData().getSlingRequestProcessor();
        eh.handleError(status, message, this.requestData.getSlingRequest(), this);
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter result = super.getWriter();
        if (this.firstSlingResponse) {
            final PrintWriter delegatee = result;
            result = new PrintWriter(result){
                private boolean isClosed;
                {
                    super(x0);
                    this.isClosed = false;
                }

                private void checkClosed() {
                    if (this.isClosed) {
                        throw new WriterAlreadyClosedException();
                    }
                }

                public PrintWriter append(char arg0) {
                    this.checkClosed();
                    return delegatee.append(arg0);
                }

                public PrintWriter append(CharSequence arg0, int arg1, int arg2) {
                    this.checkClosed();
                    return delegatee.append(arg0, arg1, arg2);
                }

                public PrintWriter append(CharSequence arg0) {
                    this.checkClosed();
                    return delegatee.append(arg0);
                }

                public boolean checkError() {
                    this.checkClosed();
                    return delegatee.checkError();
                }

                public void close() {
                    this.checkClosed();
                    this.isClosed = true;
                    delegatee.close();
                }

                public void flush() {
                    this.checkClosed();
                    delegatee.flush();
                }

                public PrintWriter format(Locale arg0, String arg1, Object ... arg2) {
                    this.checkClosed();
                    return delegatee.format(arg0, arg1, arg2);
                }

                public PrintWriter format(String arg0, Object ... arg1) {
                    this.checkClosed();
                    return delegatee.format(arg0, arg1);
                }

                public void print(boolean arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(char arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(char[] arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(double arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(float arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(int arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(long arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(Object arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public void print(String arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                public PrintWriter printf(Locale arg0, String arg1, Object ... arg2) {
                    this.checkClosed();
                    return delegatee.printf(arg0, arg1, arg2);
                }

                public PrintWriter printf(String arg0, Object ... arg1) {
                    this.checkClosed();
                    return delegatee.printf(arg0, arg1);
                }

                public void println() {
                    this.checkClosed();
                    delegatee.println();
                }

                public void println(boolean arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(char arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(char[] arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(double arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(float arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(int arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(long arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(Object arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void println(String arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                public void write(char[] arg0, int arg1, int arg2) {
                    this.checkClosed();
                    delegatee.write(arg0, arg1, arg2);
                }

                public void write(char[] arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }

                public void write(int arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }

                public void write(String arg0, int arg1, int arg2) {
                    this.checkClosed();
                    delegatee.write(arg0, arg1, arg2);
                }

                public void write(String arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }
            };
        }
        return result;
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed");
        }
    }

    private String makeAbsolutePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String base = this.getRequestData().getContentData().getResource().getPath();
        int lastSlash = base.lastIndexOf(47);
        path = lastSlash >= 0 ? base.substring(0, lastSlash + 1) + path : "/" + path;
        return path;
    }

    private String map(String url) {
        return this.getRequestData().getResourceResolver().map(this.getRequestData().getServletRequest(), url);
    }

    private String removeContextPath(String path) {
        String contextPath = this.getRequestData().getSlingRequest().getContextPath().concat("/");
        if (contextPath.length() > 1 && path.startsWith(contextPath)) {
            return path.substring(contextPath.length() - 1);
        }
        return path;
    }

    public static class WriterAlreadyClosedException
    extends IllegalStateException {
    }
}

