/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.filter.SlingFilterChainHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebConsoleConfigPrinter {
    private final ServletFilterManager filterManager;

    public WebConsoleConfigPrinter(ServletFilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public static Object register(BundleContext bundleContext, ServletFilterManager filterManager) {
        Registration reg = new Registration();
        WebConsoleConfigPrinter filterPrinter = new WebConsoleConfigPrinter(filterManager);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.description", "Apache Sling Servlet Filter Configuration Printer");
        ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)serviceProps).put("felix.webconsole.label", "slingfilter");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Sling Servlet Filter");
        ((Dictionary)serviceProps).put("felix.webconsole.configprinter.modes", "always");
        reg.filterPlugin = bundleContext.registerService(WebConsoleConfigPrinter.class.getName(), (Object)filterPrinter, serviceProps);
        return reg;
    }

    public static void unregister(Object reg) {
        if (reg instanceof Registration) {
            Registration registration = (Registration)reg;
            if (registration.filterPlugin != null) {
                registration.filterPlugin.unregister();
                registration.filterPlugin = null;
            }
        }
    }

    private void printFilterChain(PrintWriter pw, SlingFilterChainHelper.FilterListEntry[] entries) {
        if (entries == null) {
            pw.println("---");
        } else {
            for (SlingFilterChainHelper.FilterListEntry entry : entries) {
                pw.print(entry.getOrder());
                pw.print(" : ");
                pw.print(entry.getFilter().getClass());
                pw.print(" (id: ");
                pw.print(entry.getFilterId());
                pw.print(", property: ");
                pw.print(entry.getOrderSource());
                pw.println(")");
            }
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Servlet Filter Configuration");
        for (ServletFilterManager.FilterChainType type : ServletFilterManager.FilterChainType.values()) {
            pw.println();
            pw.println((Object)((Object)type) + " Filters:");
            this.printFilterChain(pw, this.filterManager.getFilterChain(type).getFilterListEntries());
        }
    }

    private static final class Registration {
        public ServiceRegistration filterPlugin;

        private Registration() {
        }
    }
}

