/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.engine.RequestLog;

class FileRequestLog
implements RequestLog {
    private static Map<String, PrintWriter> logFiles = new HashMap<String, PrintWriter>();
    private PrintWriter output;

    static void dispose() {
        for (PrintWriter w : logFiles.values()) {
            try {
                ((Writer)w).close();
            }
            catch (IOException iOException) {}
        }
        logFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileRequestLog(File logFile) throws IOException {
        Map<String, PrintWriter> map = logFiles;
        synchronized (map) {
            String fileName = logFile.getAbsolutePath();
            this.output = logFiles.get(fileName);
            if (this.output == null) {
                logFile.getParentFile().mkdirs();
                FileWriter fw = new FileWriter(logFile, true);
                this.output = new PrintWriter(fw);
                logFiles.put(fileName, this.output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String message) {
        PrintWriter writer = this.output;
        if (writer != null) {
            PrintWriter printWriter = writer;
            synchronized (printWriter) {
                writer.println(message);
                writer.flush();
            }
        }
    }

    @Override
    public void close() {
        this.output = null;
    }
}

