/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.i18n.DefaultLocaleResolver;
import org.apache.sling.i18n.LocaleResolver;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger((String)I18NFilter.class.getName());
    private static LocaleResolver DEFAULT_LOCALE_RESOLVER = new DefaultLocaleResolver();
    private LocaleResolver localeResolver = DEFAULT_LOCALE_RESOLVER;
    private ResourceBundleProvider resourceBundleProvider;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request = new I18NSlingHttpServletRequest((ServletRequest)request, this.resourceBundleProvider, this.localeResolver);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected void bindLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    protected void unbindLocaleResolver(LocaleResolver localeResolver) {
        if (this.localeResolver == localeResolver) {
            this.localeResolver = DEFAULT_LOCALE_RESOLVER;
        }
    }

    protected void bindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.resourceBundleProvider = resourceBundleProvider;
    }

    protected void unbindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        if (this.resourceBundleProvider == resourceBundleProvider) {
            this.resourceBundleProvider = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class I18NSlingHttpServletRequest
    extends SlingHttpServletRequestWrapper {
        private final ResourceBundleProvider bundleProvider;
        private final LocaleResolver localeResolver;
        private Locale locale;
        private List<Locale> localeList;

        I18NSlingHttpServletRequest(ServletRequest delegatee, ResourceBundleProvider bundleProvider, LocaleResolver localeResolver) {
            super((SlingHttpServletRequest)delegatee);
            this.bundleProvider = bundleProvider;
            this.localeResolver = localeResolver;
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.getResourceBundle(null, locale);
        }

        public ResourceBundle getResourceBundle(String baseName, Locale locale) {
            if (this.bundleProvider != null) {
                if (locale == null) {
                    locale = this.getLocale();
                }
                try {
                    return this.bundleProvider.getResourceBundle(baseName, locale);
                }
                catch (MissingResourceException mre) {
                    log.warn("getResourceBundle: Cannot get ResourceBundle from provider", (Throwable)mre);
                }
            } else {
                log.info("getResourceBundle: ResourceBundleProvider not available, calling default implementation");
            }
            return super.getResourceBundle(baseName, locale);
        }

        public Locale getLocale() {
            if (this.locale == null) {
                this.locale = this.getLocaleList().get(0);
            }
            return this.locale;
        }

        public Enumeration<?> getLocales() {
            return Collections.enumeration(this.getLocaleList());
        }

        private List<Locale> getLocaleList() {
            if (this.localeList == null) {
                List<Locale> resolved = this.localeResolver.resolveLocale(this.getSlingRequest());
                this.localeList = resolved != null && !resolved.isEmpty() ? resolved : Collections.singletonList(this.bundleProvider.getDefaultLocale());
            }
            return this.localeList;
        }
    }
}

