/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.i18n.impl.JcrResourceBundle;
import org.apache.sling.i18n.impl.RootResourceBundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceBundleProvider
implements ResourceBundleProvider,
EventListener {
    private static final boolean DEFAULT_PRELOAD_BUNDLES = false;
    private static final String PROP_USER = "user";
    private static final String PROP_PASS = "password";
    private static final String PROP_DEFAULT_LOCALE = "locale.default";
    private static final String PROP_PRELOAD_BUNDLES = "preload.bundles";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ResourceResolverFactory resourceResolverFactory;
    private Locale defaultLocale = Locale.ENGLISH;
    private Map<String, Object> repoCredentials;
    private ResourceResolver resourceResolver;
    private final ConcurrentHashMap<Key, ResourceBundle> resourceBundleCache = new ConcurrentHashMap();
    private ResourceBundle rootResourceBundle;
    private BundleContext bundleContext;
    private List<ServiceRegistration> bundleServiceRegistrations;
    private boolean preloadBundles;

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        return this.getResourceBundleInternal(baseName, locale);
    }

    public void onEvent(EventIterator events) {
        this.log.debug("onEvent: Resource changes, removing cached ResourceBundles");
        this.clearCache();
        this.preloadBundles();
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        String user = OsgiUtil.toString(props.get(PROP_USER), null);
        if (user == null || user.length() == 0) {
            this.repoCredentials = null;
        } else {
            String pass = OsgiUtil.toString(props.get(PROP_PASS), null);
            char[] pwd = pass == null ? new char[]{} : pass.toCharArray();
            this.repoCredentials = new HashMap<String, Object>();
            this.repoCredentials.put("user.name", user);
            this.repoCredentials.put("user.password", pwd);
        }
        String localeString = OsgiUtil.toString(props.get(PROP_DEFAULT_LOCALE), null);
        this.defaultLocale = this.toLocale(localeString);
        this.preloadBundles = OsgiUtil.toBoolean(props.get(PROP_PRELOAD_BUNDLES), (boolean)false);
        this.bundleContext = context.getBundleContext();
        this.bundleServiceRegistrations = new ArrayList<ServiceRegistration>();
        if (this.resourceResolverFactory != null) {
            Thread t = new Thread(){

                public void run() {
                    JcrResourceBundleProvider.this.preloadBundles();
                }
            };
            t.start();
        }
    }

    protected void deactivate() {
        this.clearCache();
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory != null) {
            this.releaseRepository();
        }
        this.resourceResolverFactory = resourceResolverFactory;
        if (this.bundleContext != null) {
            this.preloadBundles();
        }
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.releaseRepository();
            this.resourceResolverFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleInternal(String baseName, Locale locale) {
        Key key = new Key(baseName, locale);
        ResourceBundle resourceBundle = this.resourceBundleCache.get(key);
        if (resourceBundle == null) {
            this.log.debug("getResourceBundleInternal({}, {}): reading from Repository", new Object[]{baseName, locale});
            resourceBundle = this.createResourceBundle(baseName, locale);
            if (this.resourceBundleCache.putIfAbsent(key, resourceBundle) != null) {
                resourceBundle = this.resourceBundleCache.get(key);
                this.log.debug("getResourceBundleInternal({}, {}): duplicate creation, using existing ResourceBundle", new Object[]{baseName, locale});
            } else {
                Hashtable<String, String> serviceProps = new Hashtable<String, String>();
                if (key.baseName != null) {
                    ((Dictionary)serviceProps).put("baseName", key.baseName);
                }
                ((Dictionary)serviceProps).put("locale", key.locale.toString());
                ServiceRegistration serviceReg = this.bundleContext.registerService(ResourceBundle.class.getName(), (Object)resourceBundle, serviceProps);
                JcrResourceBundleProvider jcrResourceBundleProvider = this;
                synchronized (jcrResourceBundleProvider) {
                    this.bundleServiceRegistrations.add(serviceReg);
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getResourceBundleInternal({}, {}) ==> {}", new Object[]{baseName, locale, resourceBundle});
        }
        return resourceBundle;
    }

    private ResourceBundle createResourceBundle(String baseName, Locale locale) {
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            this.log.info("createResourceBundle: Missing Resource Resolver, cannot create Resource Bundle");
            throw new MissingResourceException("ResourceResolver not available", this.getClass().getName(), "");
        }
        JcrResourceBundle bundle = new JcrResourceBundle(locale, baseName, resolver);
        Locale parentLocale = this.getParentLocale(locale);
        if (parentLocale != null) {
            bundle.setParent(this.getResourceBundleInternal(baseName, parentLocale));
        } else {
            bundle.setParent(this.getRootResourceBundle());
        }
        return bundle;
    }

    private Locale getParentLocale(Locale locale) {
        if (locale.getVariant().length() != 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry().length() != 0) {
            return new Locale(locale.getLanguage());
        }
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            return this.defaultLocale;
        }
        return null;
    }

    private ResourceBundle getRootResourceBundle() {
        if (this.rootResourceBundle == null) {
            this.rootResourceBundle = new RootResourceBundle();
        }
        return this.rootResourceBundle;
    }

    private ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            ResourceResolverFactory fac = this.resourceResolverFactory;
            if (fac == null) {
                this.log.error("getResourceResolver: ResourceResolverFactory is missing. Cannot create ResourceResolver");
            } else {
                ResourceResolver resolver = null;
                try {
                    resolver = this.repoCredentials == null ? fac.getAdministrativeResourceResolver(null) : fac.getResourceResolver(this.repoCredentials);
                    Session s = (Session)resolver.adaptTo(Session.class);
                    ObservationManager om = s.getWorkspace().getObservationManager();
                    om.addEventListener((EventListener)this, 255, "/", true, null, new String[]{"mix:language", "sling:Message"}, true);
                    this.resourceResolver = resolver;
                }
                catch (RepositoryException re) {
                    this.log.error("getResourceResolver: Problem setting up ResourceResolver with Session", (Throwable)re);
                }
                catch (LoginException le) {
                    this.log.error("getResourceResolver: Problem setting up ResourceResolver with Session", (Throwable)le);
                }
            }
        }
        return this.resourceResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        ServiceRegistration[] serviceRegs;
        this.resourceBundleCache.clear();
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            serviceRegs = this.bundleServiceRegistrations.toArray(new ServiceRegistration[this.bundleServiceRegistrations.size()]);
            this.bundleServiceRegistrations.clear();
        }
        for (ServiceRegistration serviceReg : serviceRegs) {
            serviceReg.unregister();
        }
    }

    private void preloadBundles() {
        if (this.preloadBundles) {
            Iterator bundles = this.getResourceResolver().queryResources("//element(*,mix:language)", "xpath");
            HashSet<Key> usedKeys = new HashSet<Key>();
            while (bundles.hasNext()) {
                Key key;
                Map bundle = (Map)bundles.next();
                if (!bundle.containsKey("jcr:language")) continue;
                Locale locale = this.toLocale(bundle.get("jcr:language").toString());
                String baseName = null;
                if (bundle.containsKey("sling:basename")) {
                    baseName = bundle.get("sling:basename").toString();
                }
                if (!usedKeys.add(key = new Key(baseName, locale))) continue;
                this.getResourceBundle(baseName, locale);
            }
        }
    }

    private void releaseRepository() {
        ResourceResolver resolver = this.resourceResolver;
        this.resourceResolver = null;
        this.clearCache();
        if (resolver != null) {
            Session s = (Session)resolver.adaptTo(Session.class);
            if (s != null) {
                try {
                    ObservationManager om = s.getWorkspace().getObservationManager();
                    om.removeEventListener((EventListener)this);
                }
                catch (Throwable t) {
                    this.log.info("releaseRepository: Problem unregistering as event listener", t);
                }
            }
            try {
                resolver.close();
            }
            catch (Throwable t) {
                this.log.info("releaseRepository: Unexpected problem closing the ResourceResolver", t);
            }
        }
    }

    private Locale toLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] parts = localeString.split("_");
        if (parts.length == 0) {
            return Locale.getDefault();
        }
        String lang = parts[0];
        String[] langs = Locale.getISOLanguages();
        for (int i = 0; i < langs.length; ++i) {
            if (!langs[i].equals(lang)) continue;
            lang = null;
            break;
        }
        if (lang != null) {
            parts[0] = Locale.getDefault().getLanguage();
        }
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        String country = parts[1];
        String[] countries = Locale.getISOCountries();
        for (int i = 0; i < countries.length; ++i) {
            if (!countries[i].equals(lang)) continue;
            country = null;
            break;
        }
        if (country != null) {
            parts[1] = Locale.getDefault().getCountry();
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    private static class Key {
        final String baseName;
        final Locale locale;
        final int hashCode;

        Key(String baseName, Locale locale) {
            int hc = 0;
            if (baseName != null) {
                hc += 17 * baseName.hashCode();
            }
            if (locale != null) {
                hc += 13 * locale.hashCode();
            }
            this.baseName = baseName;
            this.locale = locale;
            this.hashCode = hc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Key.equals(this.baseName, other.baseName) && Key.equals(this.locale, other.locale);
            }
            return false;
        }

        private static boolean equals(Object o1, Object o2) {
            return !(o1 == null ? o2 != null : !o1.equals(o2));
        }
    }
}

