/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.i18n.impl.ResourceBundleEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceBundle
extends ResourceBundle {
    private static final Logger log = LoggerFactory.getLogger(JcrResourceBundle.class);
    static final String JCR_PATH = "jcr:path";
    static final String PROP_KEY = "sling:key";
    static final String PROP_VALUE = "sling:message";
    static final String PROP_BASENAME = "sling:basename";
    static final String PROP_LANGUAGE = "jcr:language";
    private static final String QUERY_MESSAGES_FORMAT = "/jcr:root%s//element(*,sling:Message)";
    static final String QUERY_LANGUAGE_ROOTS = "//element(*,mix:language)[@jcr:language]";
    private final Map<String, Object> resources;
    private final Locale locale;
    private final Set<String> languageRoots = new HashSet<String>();

    JcrResourceBundle(Locale locale, String baseName, ResourceResolver resourceResolver) {
        this.locale = locale;
        long start = System.currentTimeMillis();
        JcrResourceBundle.refreshSession(resourceResolver);
        Set<String> roots = this.loadPotentialLanguageRoots(resourceResolver, locale, baseName);
        this.resources = this.loadFully(resourceResolver, roots, this.languageRoots);
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("JcrResourceBundle: Fully loaded {} entries for {} (base: {}) in {}ms", new Object[]{this.resources.size(), locale, baseName, end - start});
            log.debug("JcrResourceBundle: Language roots: {}", this.languageRoots);
        }
    }

    static void refreshSession(ResourceResolver resolver) {
        resolver.refresh();
    }

    protected Set<String> getLanguageRootPaths() {
        return this.languageRoots;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.resources.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<String> parentKeys = this.parent != null ? this.parent.getKeys() : null;
        return new ResourceBundleEnumeration(this.resources.keySet(), parentKeys);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.resources.get(key);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> loadFully(ResourceResolver resourceResolver, Set<String> roots, Set<String> languageRoots) {
        ArrayList allResources = new ArrayList();
        String[] path = resourceResolver.getSearchPath();
        for (String root : roots) {
            int i;
            void var9_14;
            String string = String.format(QUERY_MESSAGES_FORMAT, ISO9075.encodePath(root));
            log.debug("Executing full load query {}", (Object)string);
            Object var9_15 = null;
            try {
                Iterator iterator = resourceResolver.queryResources(string, "xpath");
            }
            catch (SlingException se) {
                log.error("Exception during resource query " + string, (Throwable)se);
            }
            if (var9_14 == null) continue;
            HashMap rest = new HashMap();
            ArrayList res0 = new ArrayList();
            for (i = 0; i < path.length; ++i) {
                res0.add(new HashMap());
            }
            res0.add(rest);
            allResources.add(res0);
            while (var9_14.hasNext()) {
                Map row = (Map)var9_14.next();
                if (!row.containsKey(PROP_VALUE)) continue;
                String jcrPath = (String)row.get(JCR_PATH);
                String key = (String)row.get(PROP_KEY);
                if (key == null) {
                    key = ResourceUtil.getName((String)jcrPath);
                }
                Map dst = rest;
                for (int i2 = 0; i2 < path.length; ++i2) {
                    if (!jcrPath.startsWith(path[i2])) continue;
                    dst = (Map)res0.get(i2);
                    break;
                }
                dst.put(key, row.get(PROP_VALUE));
            }
            for (i = path.length - 1; i >= 0; --i) {
                Map resources = (Map)res0.get(i);
                if (resources.isEmpty()) continue;
                languageRoots.add(root);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (List list : allResources) {
            Map map = (Map)list.get(list.size() - 1);
            result.putAll(map);
        }
        for (int i = path.length - 1; i >= 0; --i) {
            for (List list : allResources) {
                Map resources = (Map)list.get(i);
                result.putAll(resources);
            }
        }
        return result;
    }

    private Set<String> loadPotentialLanguageRoots(ResourceResolver resourceResolver, Locale locale, String baseName) {
        String localeString = locale.toString();
        String localeStringLower = localeString.toLowerCase();
        String localeRFC4646String = JcrResourceBundle.toRFC4646String(locale);
        String localeRFC4646StringLower = localeRFC4646String.toLowerCase();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        Iterator bundles = resourceResolver.findResources(QUERY_LANGUAGE_ROOTS, "xpath");
        while (bundles.hasNext()) {
            Resource bundle = (Resource)bundles.next();
            ValueMap properties = (ValueMap)bundle.adaptTo(ValueMap.class);
            String language = (String)properties.get(PROP_LANGUAGE, String.class);
            if (language == null || language.length() <= 0 || !language.equals(localeString) && !language.equals(localeStringLower) && !language.equals(localeRFC4646String) && !language.equals(localeRFC4646StringLower) || baseName != null && !baseName.equals(properties.get(PROP_BASENAME, (Object)""))) continue;
            paths.add(bundle.getPath());
        }
        return Collections.unmodifiableSet(paths);
    }

    private static String toRFC4646String(Locale locale) {
        return locale.toString().replace('_', '-');
    }
}

