/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNodeConverter
implements JcrInstaller.NodeConverter {
    public static final String FILENAME_REGEXP = "[a-zA-Z0-9].*\\.(jar|cfg|properties)";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_CONTENT_DATA = "jcr:content/jcr:data";
    public static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    public static final String JCR_CONTENT_LAST_MODIFIED = "jcr:content/jcr:lastModified";
    private final Pattern namePattern = Pattern.compile("[a-zA-Z0-9].*\\.(jar|cfg|properties)");
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public InstallableResource convertNode(Node n, int priority) throws RepositoryException {
        InstallableResource result = null;
        if (n.hasProperty(JCR_CONTENT_DATA) && n.hasProperty(JCR_CONTENT_LAST_MODIFIED)) {
            if (this.acceptNodeName(n.getName())) {
                try {
                    result = this.convert(n, n.getPath(), priority);
                }
                catch (IOException ioe) {
                    this.log.info("Conversion failed, node {} ignored ({})", (Object)n.getPath(), (Object)ioe);
                }
            } else {
                this.log.debug("Node {} ignored due to {}", (Object)n.getPath(), (Object)this.namePattern);
            }
            return result;
        }
        this.log.debug("Node {} has no {} properties, ignored", (Object)n.getPath(), (Object)"jcr:content/jcr:data or jcr:content/jcr:lastModified");
        return null;
    }

    private InstallableResource convert(Node n, String path, int priority) throws IOException, RepositoryException {
        String digest = null;
        if (!n.hasProperty(JCR_CONTENT_LAST_MODIFIED)) {
            throw new IOException("Missing jcr:content/jcr:lastModified property");
        }
        digest = String.valueOf(n.getProperty(JCR_CONTENT_LAST_MODIFIED).getDate().getTimeInMillis());
        InputStream is = null;
        if (!n.hasProperty(JCR_CONTENT_DATA)) {
            throw new IOException("Missing jcr:content/jcr:data property");
        }
        is = n.getProperty(JCR_CONTENT_DATA).getStream();
        return new InstallableResource(path, is, null, digest, null, Integer.valueOf(priority));
    }

    boolean acceptNodeName(String name) {
        return this.namePattern.matcher(name).matches();
    }
}

