/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderNameFilter {
    private final Pattern pattern;
    private final String regexp;
    private final Set<String> runModes;
    private final String[] rootPaths;
    private final Map<String, Integer> rootPriorities = new HashMap<String, Integer>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int RUNMODE_PRIORITY_BOOST = 1;
    public static final int DEFAULT_ROOT_PRIORITY = 99;

    FolderNameFilter(String[] rootsConfig, String regexp, Set<String> runModes) {
        this.regexp = regexp;
        this.pattern = Pattern.compile(regexp);
        this.runModes = runModes;
        this.rootPaths = new String[rootsConfig.length];
        for (int i = 0; i < rootsConfig.length; ++i) {
            String[] parts = rootsConfig[i].split(":");
            this.rootPaths[i] = FolderNameFilter.cleanupRootPath(parts[0]);
            Integer priority = new Integer(99);
            if (parts.length > 1) {
                try {
                    priority = Integer.parseInt(parts[1].trim());
                }
                catch (NumberFormatException nfe) {
                    this.log.warn("Invalid priority in path definition '{}'", (Object)rootsConfig[i]);
                }
            }
            this.rootPriorities.put(this.rootPaths[i], priority);
            this.log.debug("Root path {} has priority {}", (Object)this.rootPaths[i], (Object)priority);
        }
    }

    String[] getRootPaths() {
        return this.rootPaths;
    }

    static String cleanupRootPath(String str) {
        String result = str.trim();
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    int getPriority(String path) {
        int result = 0;
        LinkedList<String> modes = null;
        boolean match = false;
        int DOT = 46;
        String prefix = path;
        int lastSlash = prefix.lastIndexOf(47);
        if (lastSlash > 0) {
            prefix = prefix.substring(lastSlash);
        }
        if (prefix.indexOf(46) > 0) {
            int pos = 0;
            modes = new LinkedList<String>();
            while ((pos = prefix.lastIndexOf(46)) >= 0) {
                modes.add(prefix.substring(pos + 1));
                if (!this.pattern.matcher(prefix = prefix.substring(0, pos)).matches()) continue;
                result = this.getRootPriority(path);
                break;
            }
            if (result > 0) {
                for (String m : modes) {
                    if (this.runModes.contains(m)) {
                        ++result;
                        continue;
                    }
                    result = 0;
                    break;
                }
            }
        } else if (this.pattern.matcher(path).matches()) {
            match = true;
            result = this.getRootPriority(path);
        }
        if (modes != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getPriority(" + path + ")=" + result + " (prefix=" + prefix + ", run modes=" + modes + ")");
            }
        } else if (match) {
            this.log.debug("getPriority({})={}", (Object)path, (Object)result);
        } else {
            this.log.debug("getPriority({})={}, path doesn't match regexp", (Object)path, (Object)result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.regexp + "), RunModes=" + this.runModes;
    }

    int getRootPriority(String path) {
        for (Map.Entry<String, Integer> e : this.rootPriorities.entrySet()) {
            if (!path.startsWith(e.getKey())) continue;
            return e.getValue();
        }
        return 0;
    }
}

