/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNodeConverter
implements JcrInstaller.NodeConverter {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_DATA = "jcr:content/jcr:data";
    private static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    private static final String JCR_CONTENT_LAST_MODIFIED = "jcr:content/jcr:lastModified";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public InstallableResource convertNode(Node n, int priority) throws RepositoryException {
        InstallableResource result = null;
        if (n.hasProperty(JCR_CONTENT_DATA) && n.hasProperty(JCR_CONTENT_LAST_MODIFIED)) {
            try {
                result = this.convert(n, n.getPath(), priority);
            }
            catch (IOException ioe) {
                this.log.info("Conversion failed, node {} ignored ({})", (Object)n.getPath(), (Object)ioe);
            }
            return result;
        }
        this.log.debug("Node {} has no {} properties, ignored", (Object)n.getPath(), (Object)"jcr:content/jcr:data or jcr:content/jcr:lastModified");
        return null;
    }

    private InstallableResource convert(Node n, String path, int priority) throws IOException, RepositoryException {
        String digest = null;
        if (!n.hasProperty(JCR_CONTENT_LAST_MODIFIED)) {
            throw new IOException("Missing jcr:content/jcr:lastModified property");
        }
        digest = String.valueOf(n.getProperty(JCR_CONTENT_LAST_MODIFIED).getDate().getTimeInMillis());
        InputStream is = null;
        if (!n.hasProperty(JCR_CONTENT_DATA)) {
            throw new IOException("Missing jcr:content/jcr:data property");
        }
        is = n.getProperty(JCR_CONTENT_DATA).getStream();
        return new InstallableResource(path, is, null, digest, null, Integer.valueOf(priority));
    }
}

