/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractSlingRepository;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AdministrativeCredentials;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AnonCredentials;
import org.osgi.framework.Bundle;

public class SlingServerRepository
extends AbstractSlingRepository
implements Repository,
SlingRepository {
    public static final String REPOSITORY_CONFIG_URL = "config";
    public static final String REPOSITORY_HOME_DIR = "home";
    public static final String REPOSITORY_REGISTRATION_NAME = "name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository acquireRepository() {
        Repository repository = super.acquireRepository();
        if (repository != null) {
            return repository;
        }
        Dictionary environment = this.getComponentContext().getProperties();
        String configURLObj = (String)environment.get(REPOSITORY_CONFIG_URL);
        String home = (String)environment.get(REPOSITORY_HOME_DIR);
        if (System.getProperty("derby.stream.error.file") == null) {
            String derbyLog = home + "/derby.log";
            System.setProperty("derby.stream.error.file", derbyLog);
        }
        InputStream ins = null;
        try {
            File configFile = new File(configURLObj);
            if (configFile.canRead()) {
                ins = new FileInputStream(configFile);
                this.log(3, "Using configuration file " + configFile.getAbsolutePath());
            } else {
                try {
                    URL configURL = new URL(configURLObj);
                    ins = configURL.openStream();
                    this.log(3, "Using configuration URL " + configURL);
                }
                catch (MalformedURLException mue) {
                    this.log(3, "Configuration File " + configFile.getAbsolutePath() + " has been lost, trying to recreate");
                    Bundle bundle = this.getComponentContext().getBundleContext().getBundle();
                    SlingServerRepository.copyFile(bundle, "repository.xml", configFile);
                    ins = new FileInputStream(configFile);
                    this.log(3, "Using configuration file " + configFile.getAbsolutePath());
                }
            }
            RepositoryConfig crc = RepositoryConfig.create((InputStream)ins, (String)home);
            RepositoryImpl repositoryImpl = RepositoryImpl.create((RepositoryConfig)crc);
            return repositoryImpl;
        }
        catch (IOException ioe) {
            this.log(1, "acquireRepository: IO problem starting repository from " + configURLObj + " in " + home, ioe);
        }
        catch (RepositoryException re) {
            this.log(1, "acquireRepository: Repository problem starting repository from " + configURLObj + " in " + home, re);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    protected void disposeRepository(Repository repository) {
        super.disposeRepository(repository);
        if (repository instanceof RepositoryImpl) {
            try {
                ((RepositoryImpl)repository).shutdown();
            }
            catch (Throwable t) {
                this.log(1, "deactivate: Unexpected problem shutting down repository", t);
            }
        } else {
            this.log(3, "Repository is not a RepositoryImpl, nothing to do");
        }
    }

    public static void copyFile(Bundle bundle, String entryPath, File destFile) throws FileNotFoundException, IOException {
        if (destFile.canRead()) {
            return;
        }
        URL entryURL = bundle.getEntry(entryPath);
        if (entryURL == null) {
            throw new FileNotFoundException(entryPath);
        }
        InputStream source = entryURL.openStream();
        SlingServerRepository.copyStream(source, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream source, File destFile) throws FileNotFoundException, IOException {
        OutputStream dest = null;
        try {
            int rd;
            destFile.getParentFile().mkdirs();
            dest = new FileOutputStream(destFile);
            byte[] buf = new byte[2048];
            while ((rd = source.read(buf)) >= 0) {
                dest.write(buf, 0, rd);
            }
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException ignore) {}
            }
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Credentials getAdministrativeCredentials(String adminUser) {
        return new AdministrativeCredentials(adminUser);
    }

    protected Credentials getAnonCredentials(String anonUser) {
        return new AnonCredentials(anonUser);
    }
}

