/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.management.DynamicMBean;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.api.management.DataStoreGarbageCollector;
import org.apache.jackrabbit.api.management.RepositoryManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractSlingRepository;
import org.apache.sling.jcr.jackrabbit.server.impl.jmx.StatisticsMBeanImpl;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AdministrativeCredentials;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AnonCredentials;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%repository.name", description="%repository.description", metatype=true, name="org.apache.sling.jcr.jackrabbit.server.SlingServerRepository", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Factory for embedded Jackrabbit Repository Instances"})})
public class SlingServerRepository
extends AbstractSlingRepository
implements Repository,
SlingRepository,
RepositoryManager {
    @Property(value={""})
    public static final String REPOSITORY_CONFIG_URL = "config";
    @Property(value={""})
    public static final String REPOSITORY_HOME_DIR = "home";
    @Property(value={""})
    public static final String REPOSITORY_REGISTRATION_NAME = "name";
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingServerRepository.class);
    private Map<String, ServiceRegistration> statisticsServices = new ConcurrentHashMap<String, ServiceRegistration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository acquireRepository() {
        Repository repository = super.acquireRepository();
        if (repository != null) {
            return this.registerStatistics(repository);
        }
        Dictionary environment = this.getComponentContext().getProperties();
        String configURLObj = (String)environment.get(REPOSITORY_CONFIG_URL);
        String home = (String)environment.get(REPOSITORY_HOME_DIR);
        File homeFile = new File(home);
        if (!homeFile.isAbsolute()) {
            BundleContext context = this.getComponentContext().getBundleContext();
            String slingHomePath = context.getProperty("sling.home");
            homeFile = slingHomePath != null ? new File(slingHomePath, home) : homeFile.getAbsoluteFile();
            home = homeFile.getAbsolutePath();
        }
        if (System.getProperty("derby.stream.error.file") == null) {
            String derbyLog = home + "/derby.log";
            System.setProperty("derby.stream.error.file", derbyLog);
        }
        InputStream ins = null;
        try {
            RepositoryConfig crc;
            if (configURLObj != null && configURLObj.length() > 0) {
                File configFile = new File(configURLObj);
                if (configFile.canRead()) {
                    ins = new FileInputStream(configFile);
                    this.log(3, "Using configuration file " + configFile.getAbsolutePath());
                } else {
                    try {
                        URL configURL = new URL(configURLObj);
                        ins = configURL.openStream();
                        this.log(3, "Using configuration URL " + configURL);
                    }
                    catch (MalformedURLException mue) {
                        this.log(3, "Configuration File " + configFile.getAbsolutePath() + " has been lost, trying to recreate");
                        Bundle bundle = this.getComponentContext().getBundleContext().getBundle();
                        SlingServerRepository.copyFile(bundle, "repository.xml", configFile);
                        ins = new FileInputStream(configFile);
                        this.log(3, "Using configuration file " + configFile.getAbsolutePath());
                    }
                }
                crc = RepositoryConfig.create((InputStream)ins, (String)home);
            } else {
                crc = RepositoryConfig.create((File)homeFile);
            }
            Repository repository2 = this.registerStatistics((Repository)RepositoryImpl.create((RepositoryConfig)crc));
            return repository2;
        }
        catch (IOException ioe) {
            this.log(1, "acquireRepository: IO problem starting repository from " + configURLObj + " in " + home, ioe);
        }
        catch (RepositoryException re) {
            this.log(1, "acquireRepository: Repository problem starting repository from " + configURLObj + " in " + home, re);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    private Repository registerStatistics(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            try {
                RepositoryImpl repositoryImpl = (RepositoryImpl)repository;
                StatisticsMBeanImpl mbean = new StatisticsMBeanImpl(repositoryImpl);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                String mbeanName = StatisticsMBeanImpl.getMBeanName(repositoryImpl);
                ((Dictionary)properties).put("jmx.objectname", mbeanName);
                ((Dictionary)properties).put("service.vendor", "Apache");
                this.statisticsServices.put(mbeanName, this.getComponentContext().getBundleContext().registerService(DynamicMBean.class.getName(), (Object)mbean, properties));
            }
            catch (Exception e) {
                LOGGER.error("Unable to register statistics ", (Throwable)e);
            }
        }
        return repository;
    }

    protected void disposeRepository(Repository repository) {
        super.disposeRepository(repository);
        this.unregisterStatistics(repository);
        if (repository instanceof RepositoryImpl) {
            try {
                ((RepositoryImpl)repository).shutdown();
            }
            catch (Throwable t) {
                this.log(1, "deactivate: Unexpected problem shutting down repository", t);
            }
        } else {
            this.log(3, "Repository is not a RepositoryImpl, nothing to do");
        }
    }

    private void unregisterStatistics(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            String mbeanName = StatisticsMBeanImpl.getMBeanName((RepositoryImpl)repository);
            try {
                ServiceRegistration serviceRegistration = this.statisticsServices.get(mbeanName);
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to unregister statistics JMX bean {} ", (Object)e.getMessage());
            }
            this.statisticsServices.remove(mbeanName);
        }
    }

    public void stop() {
        throw new UnsupportedOperationException("Not allowed to manually stop the repository");
    }

    public DataStoreGarbageCollector createDataStoreGarbageCollector() throws RepositoryException {
        RepositoryImpl repository = (RepositoryImpl)this.getRepository();
        if (repository != null) {
            return repository.createDataStoreGarbageCollector();
        }
        throw new RepositoryException("Repository couldn't be acquired");
    }

    protected ServiceRegistration registerService() {
        Dictionary props = this.getComponentContext().getProperties();
        String[] interfaces = new String[]{SlingRepository.class.getName(), Repository.class.getName(), RepositoryManager.class.getName()};
        return this.getComponentContext().getBundleContext().registerService(interfaces, (Object)this, props);
    }

    public static void copyFile(Bundle bundle, String entryPath, File destFile) throws FileNotFoundException, IOException {
        if (destFile.canRead()) {
            return;
        }
        URL entryURL = bundle.getEntry(entryPath);
        if (entryURL == null) {
            throw new FileNotFoundException(entryPath);
        }
        InputStream source = entryURL.openStream();
        SlingServerRepository.copyStream(source, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream source, File destFile) throws FileNotFoundException, IOException {
        OutputStream dest = null;
        try {
            int rd;
            destFile.getParentFile().mkdirs();
            dest = new FileOutputStream(destFile);
            byte[] buf = new byte[2048];
            while ((rd = source.read(buf)) >= 0) {
                dest.write(buf, 0, rd);
            }
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException ignore) {}
            }
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Credentials getAdministrativeCredentials(String adminUser) {
        return new AdministrativeCredentials(adminUser);
    }

    protected Credentials getAnonCredentials(String anonUser) {
        return new AnonCredentials(anonUser);
    }
}

