/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.jcr.api.SlingRepository;

@Component
@Service(value={ConfigurationPrinter.class})
@Properties(value={@Property(name="service.description", value={"JCR Namespace Configuration Printer"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class NamespaceConfigurationPrinter
implements ConfigurationPrinter {
    @Reference(policy=ReferencePolicy.DYNAMIC)
    private volatile SlingRepository slingRepository;

    public String getTitle() {
        return "JCR Namespaces";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConfiguration(PrintWriter pw) {
        if (this.slingRepository != null) {
            Session session = null;
            try {
                session = this.slingRepository.loginAdministrative(null);
                NamespaceRegistry reg = session.getWorkspace().getNamespaceRegistry();
                List<String> globalPrefixes = Arrays.asList(reg.getPrefixes());
                for (String prefix : session.getNamespacePrefixes()) {
                    if (prefix.length() <= 0) continue;
                    pw.printf("%10s = %s", prefix, session.getNamespaceURI(prefix));
                    if (globalPrefixes.contains(prefix)) {
                        pw.print(" [global]");
                    } else {
                        pw.print(" [local]");
                    }
                    pw.println();
                }
            }
            catch (RepositoryException e) {
                pw.println("Unable to output namespace mappings.");
                e.printStackTrace(pw);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        } else {
            pw.println("SlingRepository is not available.");
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

