/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jst;

import java.util.regex.Pattern;
import org.apache.sling.scripting.jst.ScriptFilteredCopy;

class BodyOnlyScriptFilteredCopy
extends ScriptFilteredCopy {
    private int state = 0;
    private final Pattern bodyStart = Pattern.compile("^out.write\\(.*<body.*");
    private final Pattern bodyEnd = Pattern.compile("^out.write\\(.*</body.*");

    BodyOnlyScriptFilteredCopy() {
    }

    protected boolean copyLine(String line) {
        boolean result = false;
        if (this.state == 0) {
            if (this.bodyStart.matcher(line).matches()) {
                this.state = 1;
            }
        } else if (this.state == 1) {
            if (this.bodyEnd.matcher(line).matches()) {
                this.state = 2;
            } else {
                result = true;
            }
        }
        return result;
    }
}

