/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.settings.impl.RunModeCommand;
import org.apache.sling.settings.impl.SlingPropertiesPrinter;
import org.apache.sling.settings.impl.SlingSettingsPrinter;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator,
BundleListener {
    private ServiceRegistration serviceRegistration;
    private BundleContext bundleContext;
    private SlingSettingsServiceImpl settingsService;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.settingsService = new SlingSettingsServiceImpl(context);
        if (this.settingsService.isDelayedStart()) {
            this.bundleContext.addBundleListener((BundleListener)this);
        } else {
            this.startService();
        }
    }

    public void bundleChanged(BundleEvent event) {
        if ("org.apache.sling.engine".equals(event.getBundle().getSymbolicName())) {
            this.settingsService.initDelayed(this.bundleContext);
            if (!this.settingsService.isDelayedStart()) {
                this.bundleContext.removeBundleListener((BundleListener)this);
                this.startService();
            }
        }
    }

    private void startService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", this.settingsService.getClass().getName());
        ((Dictionary)props).put("service.description", "Apache Sling Settings Service");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.serviceRegistration = this.bundleContext.registerService(new String[]{SlingSettingsService.class.getName()}, (Object)this.settingsService, props);
        try {
            SlingPropertiesPrinter.initPlugin(this.bundleContext);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            SlingSettingsPrinter.initPlugin(this.bundleContext, this.settingsService);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            RunModeCommand.initPlugin(this.bundleContext, this.settingsService.getRunModes());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
        try {
            RunModeCommand.destroyPlugin();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            SlingSettingsPrinter.destroyPlugin();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            SlingPropertiesPrinter.destroyPlugin();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        this.settingsService = null;
    }
}

