/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SlingSettingsPrinter
implements ConfigurationPrinter {
    private static ServiceRegistration pluginReg;
    private static String HEADLINE;
    private final SlingSettingsService settings;

    public static void initPlugin(BundleContext bundleContext, SlingSettingsService service) {
        SlingSettingsPrinter printer = new SlingSettingsPrinter(service);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Sling Settings Configuration Printer");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        pluginReg = bundleContext.registerService(ConfigurationPrinter.class.getName(), (Object)printer, props);
    }

    public static void destroyPlugin() {
        if (pluginReg != null) {
            pluginReg.unregister();
            pluginReg = null;
        }
    }

    public SlingSettingsPrinter(SlingSettingsService settings) {
        this.settings = settings;
    }

    public String getTitle() {
        return "Sling Settings";
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        pw.print("Sling ID = ");
        pw.print(this.settings.getSlingId());
        pw.println();
        pw.print("Sling Home = ");
        pw.print(this.settings.getSlingHomePath());
        pw.println();
        pw.print("Sling Home URL = ");
        pw.print(this.settings.getSlingHome());
        pw.println();
        pw.print("Run Modes = ");
        pw.print(this.settings.getRunModes());
        pw.println();
    }

    static {
        HEADLINE = "Apache Sling Settings";
    }
}

