/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;

final class ContextResourceResolverFactory {
    private ContextResourceResolverFactory() {
    }

    public static ResourceResolverFactory get(ResourceResolverType resourceResolverType) {
        try {
            ResourceResolverFactory factory = MockSling.newResourceResolverFactory(resourceResolverType);
            switch (resourceResolverType) {
                case JCR_MOCK: {
                    ContextResourceResolverFactory.initializeJcrMock(factory);
                    break;
                }
                case JCR_JACKRABBIT: {
                    ContextResourceResolverFactory.initializeJcrJackrabbit(factory);
                    break;
                }
                case RESOURCERESOLVER_MOCK: {
                    ContextResourceResolverFactory.initializeResourceResolverMock(factory);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid resource resolver type: " + (Object)((Object)resourceResolverType));
                }
            }
            return factory;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to initialize " + (Object)((Object)resourceResolverType) + " resource resolver factory.", ex);
        }
    }

    private static void initializeJcrMock(ResourceResolverFactory factory) throws RepositoryException, LoginException {
        ResourceResolver resolver = factory.getResourceResolver(null);
        Session session = (Session)resolver.adaptTo(Session.class);
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        namespaceRegistry.registerNamespace("sling", "http://sling.apache.org/jcr/sling/1.0");
    }

    private static void initializeJcrJackrabbit(ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverMock(ResourceResolverFactory factory) {
    }
}

