/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.http;

import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.retry.RetryLoop;

public class RetryingContentChecker {
    private final RequestExecutor executor;
    private final RequestBuilder builder;

    public RetryingContentChecker(RequestExecutor executor, RequestBuilder builder) {
        this.executor = executor;
        this.builder = builder;
    }

    public void check(final String path, final int expectedStatus, int timeoutSeconds, int intervalBetweenrequestsMsec) {
        RetryLoop.Condition c = new RetryLoop.Condition(){

            public String getDescription() {
                return "Expecting " + path + " to return HTTP status " + expectedStatus;
            }

            public boolean isTrue() throws Exception {
                RetryingContentChecker.this.executor.execute(RetryingContentChecker.this.builder.buildGetRequest(path, new String[0])).assertStatus(expectedStatus);
                return RetryingContentChecker.this.assertMore(RetryingContentChecker.this.executor);
            }
        };
        new RetryLoop(c, timeoutSeconds, intervalBetweenrequestsMsec){

            protected void onTimeout() {
                RetryingContentChecker.this.onTimeout();
            }
        };
    }

    protected boolean assertMore(RequestExecutor executor) throws Exception {
        return true;
    }

    protected void onTimeout() {
    }
}

