/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.jarexec;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarExecutor {
    private final File jarToExecute;
    private final String javaExecutable;
    private final int serverPort;
    private final Properties config;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_PORT = 8765;
    public static final String DEFAULT_JAR_FOLDER = "target/dependency";
    public static final String DEFAULT_JAR_NAME_REGEXP = "org.apache.sling.*jar$";
    public static final String PROP_PREFIX = "jar.executor.";
    public static final String PROP_SERVER_PORT = "jar.executor.server.port";
    public static final String PROP_JAR_FOLDER = "jar.executor.jar.folder";
    public static final String PROP_JAR_NAME_REGEXP = "jar.executor.jar.name.regexp";
    public static final String PROP_VM_OPTIONS = "jar.executor.vm.options";
    public static final String PROP_WORK_FOLDER = "jar.executor.work.folder";
    public static final String PROP_JAR_OPTIONS = "jar.executor.jar.options";

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.jarToExecute.getName() + " (port " + this.serverPort + ")";
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public JarExecutor(Properties config) throws ExecutorException {
        this.config = config;
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        String portStr = config.getProperty(PROP_SERVER_PORT);
        this.serverPort = portStr == null ? 8765 : Integer.valueOf(portStr);
        this.javaExecutable = isWindows ? "java.exe" : "java";
        String jarFolderPath = config.getProperty(PROP_JAR_FOLDER);
        jarFolderPath = jarFolderPath == null ? DEFAULT_JAR_FOLDER : jarFolderPath;
        File jarFolder = new File(jarFolderPath);
        String jarNameRegexp = config.getProperty(PROP_JAR_NAME_REGEXP);
        jarNameRegexp = jarNameRegexp == null ? DEFAULT_JAR_NAME_REGEXP : jarNameRegexp;
        Pattern jarPattern = Pattern.compile(jarNameRegexp);
        String[] candidates = jarFolder.list();
        if (candidates == null) {
            throw new ExecutorException("No files found in jar folder specified by jar.executor.jar.folder property: " + jarFolder.getAbsolutePath());
        }
        File f = null;
        if (candidates != null) {
            for (String filename : candidates) {
                if (!jarPattern.matcher(filename).matches()) continue;
                f = new File(jarFolder, filename);
                break;
            }
        }
        if (f == null) {
            throw new ExecutorException("Executable jar matching '" + jarPattern + "' not found in " + jarFolder.getAbsolutePath() + ", candidates are " + Arrays.asList(candidates));
        }
        this.jarToExecute = f;
    }

    public void start() throws Exception {
        String workFolderOption;
        ExecuteResultHandler h = new ExecuteResultHandler(){

            public void onProcessFailed(ExecuteException ex) {
                JarExecutor.this.log.error("Process execution failed:" + ex, (Throwable)ex);
            }

            public void onProcessComplete(int result) {
                JarExecutor.this.log.info("Process execution complete, exit code=" + result);
            }
        };
        String vmOptions = this.config.getProperty(PROP_VM_OPTIONS);
        DefaultExecutor e = new DefaultExecutor();
        CommandLine cl = new CommandLine(this.javaExecutable);
        if (vmOptions != null && vmOptions.length() > 0) {
            cl.addArguments(vmOptions);
        }
        cl.addArgument("-jar");
        cl.addArgument(this.jarToExecute.getAbsolutePath());
        String jarOptions = this.config.getProperty(PROP_JAR_OPTIONS);
        if (jarOptions != null && jarOptions.length() > 0) {
            jarOptions = jarOptions.replaceAll("\\$JAREXEC_SERVER_PORT\\$", String.valueOf(this.serverPort));
            this.log.info("Executable jar options: {}", (Object)jarOptions);
            cl.addArguments(jarOptions);
        }
        if ((workFolderOption = this.config.getProperty(PROP_WORK_FOLDER)) != null && workFolderOption.length() > 0) {
            File workFolder = new File(workFolderOption);
            if (!workFolder.isDirectory()) {
                throw new IOException("Work dir set by jar.executor.work.folder option does not exist: " + workFolder.getAbsolutePath());
            }
            this.log.info("Setting working directory for executable jar: {}", (Object)workFolder.getAbsolutePath());
            e.setWorkingDirectory(workFolder);
        }
        this.log.info("Executing " + cl);
        e.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        e.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        e.execute(cl, h);
    }

    public static class ExecutorException
    extends Exception {
        ExecutorException(String reason) {
            super(reason);
        }

        ExecutorException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

