/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.sling;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.jarexec.JarExecutor;
import org.apache.sling.testing.tools.osgi.WebconsoleClient;
import org.apache.sling.testing.tools.sling.TimeoutsProvider;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingTestBase {
    public static final String TEST_SERVER_URL_PROP = "test.server.url";
    public static final String SERVER_READY_TIMEOUT_PROP = "server.ready.timeout.seconds";
    public static final String SERVER_READY_PROP_PREFIX = "server.ready.path";
    public static final String KEEP_JAR_RUNNING_PROP = "keepJarRunning";
    public static final String SERVER_HOSTNAME_PROP = "test.server.hostname";
    public static final String ADDITONAL_BUNDLES_PATH = "additional.bundles.path";
    public static final String BUNDLE_TO_INSTALL_PREFIX = "sling.additional.bundle";
    public static final String ADMIN = "admin";
    private static final boolean keepJarRunning = "true".equals(System.getProperty("keepJarRunning"));
    private final String serverBaseUrl;
    private static RequestBuilder builder;
    private static DefaultHttpClient httpClient;
    private static RequestExecutor executor;
    private static WebconsoleClient webconsoleClient;
    private static boolean serverStarted;
    private static boolean serverStartedByThisClass;
    private static boolean serverReady;
    private static boolean serverReadyTestFailed;
    private static boolean extraBundlesInstalled;
    private static boolean startupInfoProvided;
    private static final Logger log;
    private static JarExecutor jarExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlingTestBase() {
        String configuredUrl;
        if (jarExecutor == null) {
            SlingTestBase slingTestBase = this;
            synchronized (slingTestBase) {
                try {
                    jarExecutor = new JarExecutor(System.getProperties());
                }
                catch (Exception e) {
                    log.error("JarExecutor setup failed", (Throwable)e);
                    Assert.fail((String)("JarExecutor setup failed: " + e));
                }
            }
        }
        if ((configuredUrl = System.getProperty(TEST_SERVER_URL_PROP)) != null) {
            this.serverBaseUrl = configuredUrl;
            serverStarted = true;
        } else {
            String serverHost = System.getProperty(SERVER_HOSTNAME_PROP);
            if (serverHost == null || serverHost.trim().length() == 0) {
                serverHost = "localhost";
            }
            this.serverBaseUrl = "http://" + serverHost + ":" + jarExecutor.getServerPort();
        }
        log.info("Server base URL={}", (Object)this.serverBaseUrl);
        builder = new RequestBuilder(this.serverBaseUrl);
        webconsoleClient = new WebconsoleClient(this.serverBaseUrl, ADMIN, ADMIN);
        builder = new RequestBuilder(this.serverBaseUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerIfNeeded() {
        try {
            if (serverStarted && !serverStartedByThisClass && !startupInfoProvided) {
                log.info("test.server.url was set: not starting server jar (" + this.serverBaseUrl + ")");
            }
            if (!serverStarted) {
                JarExecutor jarExecutor = SlingTestBase.jarExecutor;
                synchronized (jarExecutor) {
                    if (!serverStarted) {
                        SlingTestBase.jarExecutor.start();
                        serverStartedByThisClass = true;
                        serverStarted = true;
                    }
                }
            }
            startupInfoProvided = true;
            this.waitForServerReady();
            this.installExtraBundles();
            this.blockIfRequested();
        }
        catch (Exception e) {
            log.error("Exception in maybeStartServer()", (Throwable)e);
            Assert.fail((String)("maybeStartServer() failed: " + e));
        }
    }

    protected RequestBuilder getRequestBuilder() {
        this.startServerIfNeeded();
        return builder;
    }

    protected String getServerBaseUrl() {
        this.startServerIfNeeded();
        return this.serverBaseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockIfRequested() {
        if (keepJarRunning) {
            log.info("keepJarRunning set to true - entering infinite loop so that runnable jar stays up. Kill this process to exit.");
            SlingTestBase slingTestBase = this;
            synchronized (slingTestBase) {
                try {
                    this.wait();
                }
                catch (InterruptedException iex) {
                    log.info("InterruptedException in blockIfRequested");
                }
            }
        }
    }

    protected void waitForServerReady() throws Exception {
        if (serverReady) {
            return;
        }
        if (serverReadyTestFailed) {
            Assert.fail((String)"Server is not ready according to previous tests");
        }
        String sec = System.getProperty(SERVER_READY_TIMEOUT_PROP);
        int timeoutSec = TimeoutsProvider.getInstance().getTimeout(sec == null ? 60 : Integer.valueOf(sec));
        log.info("Will wait up to " + timeoutSec + " seconds for server to become ready");
        long endTime = System.currentTimeMillis() + (long)timeoutSec * 1000L;
        ArrayList<String> testPaths = new ArrayList<String>();
        TreeSet<Object> propertyNames = new TreeSet<Object>();
        propertyNames.addAll(System.getProperties().keySet());
        for (Object e : propertyNames) {
            String key = (String)e;
            if (!key.startsWith(SERVER_READY_PROP_PREFIX)) continue;
            testPaths.add(System.getProperty(key));
        }
        log.info("Checking that GET requests return expected content (timeout={} seconds): {}", (Object)timeoutSec, testPaths);
        while (System.currentTimeMillis() < endTime) {
            boolean errors = false;
            for (String p : testPaths) {
                String[] s = p.split(":");
                String path = s[0];
                String pattern = s.length > 0 ? s[1] : "";
                try {
                    executor.execute(builder.buildGetRequest(path, new String[0])).assertStatus(200).assertContentContains(pattern);
                }
                catch (AssertionError ae) {
                    errors = true;
                    log.debug("Request to {}{} failed, will retry ({})", new Object[]{this.serverBaseUrl, path, ae});
                }
                catch (Exception e) {
                    errors = true;
                    log.debug("Request to {}{} failed, will retry ({})", new Object[]{this.serverBaseUrl, path, pattern, e});
                }
            }
            if (!errors) {
                serverReady = true;
                log.info("All {} paths return expected content, server ready", (Object)testPaths.size());
                break;
            }
            Thread.sleep(TimeoutsProvider.getInstance().getTimeout(1000L));
        }
        if (!serverReady) {
            serverReadyTestFailed = true;
            String msg = "Server not ready after " + timeoutSec + " seconds, giving up";
            log.info(msg);
            Assert.fail((String)msg);
        }
    }

    protected void installExtraBundles() throws Exception {
        if (extraBundlesInstalled) {
            return;
        }
        extraBundlesInstalled = true;
        if (!serverStartedByThisClass) {
            log.info("Server was not started here, additional bundles will not be installed");
            return;
        }
        String path = System.getProperty(ADDITONAL_BUNDLES_PATH);
        if (path == null) {
            log.info("System property {} not set, additional bundles won't be installed", (Object)ADDITONAL_BUNDLES_PATH);
            return;
        }
        File dir = new File(path);
        if (!dir.isDirectory() || !dir.canRead()) {
            log.info("Cannot read additional bundles directory {}, ignored", (Object)dir.getAbsolutePath());
            return;
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        String[] files = dir.list();
        if (files != null) {
            for (String string : files) {
                if (!string.endsWith(".jar")) continue;
                bundleNames.add(string);
            }
        }
        int count = 0;
        ArrayList<String> sortedPropertyKeys = new ArrayList<String>();
        for (Object object : System.getProperties().keySet()) {
            String str = object.toString();
            if (!str.startsWith(BUNDLE_TO_INSTALL_PREFIX)) continue;
            sortedPropertyKeys.add(str);
        }
        Collections.sort(sortedPropertyKeys);
        for (String string : sortedPropertyKeys) {
            String filenamePrefix = System.getProperty(string);
            for (String bundleFilename : bundleNames) {
                if (!bundleFilename.startsWith(filenamePrefix)) continue;
                webconsoleClient.installBundle(new File(dir, bundleFilename), true);
                ++count;
            }
        }
        log.info("{} additional bundles installed from {}", (Object)count, (Object)dir.getAbsolutePath());
    }

    protected boolean isServerStartedByThisClass() {
        return serverStartedByThisClass;
    }

    protected HttpClient getHttpClient() {
        return httpClient;
    }

    protected RequestExecutor getRequestExecutor() {
        return executor;
    }

    protected WebconsoleClient getWebconsoleClient() {
        this.startServerIfNeeded();
        return webconsoleClient;
    }

    static {
        httpClient = new DefaultHttpClient();
        executor = new RequestExecutor(httpClient);
        log = LoggerFactory.getLogger(SlingTestBase.class);
    }
}

