/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.jarexec;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.exec.ProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShutdownHookSingleProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Thread shutdownHookThread;
    private Process process;
    private final int timeoutSeconds;
    private final String processInfo;

    ShutdownHookSingleProcessDestroyer(String processInfo, int timeoutSeconds) {
        this.processInfo = processInfo;
        this.timeoutSeconds = timeoutSeconds;
    }

    public synchronized boolean add(Process p) {
        if (this.process != null) {
            throw new IllegalStateException("Process already set: " + this.process);
        }
        if (this.shutdownHookThread == null) {
            this.shutdownHookThread = new Thread((Runnable)this, this.getClass().getSimpleName());
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.process = p;
        return true;
    }

    public synchronized boolean remove(Process p) {
        p = null;
        return true;
    }

    public int size() {
        return 1;
    }

    public void run() {
        this.destroyProcess(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess(boolean waitForIt) {
        Process toDestroy = null;
        ShutdownHookSingleProcessDestroyer shutdownHookSingleProcessDestroyer = this;
        synchronized (shutdownHookSingleProcessDestroyer) {
            toDestroy = this.process;
            this.process = null;
        }
        if (toDestroy == null) {
            return;
        }
        toDestroy.destroy();
        if (waitForIt) {
            this.log.info("Waiting for destroyed process {} to exit (timeout={} seconds)", (Object)this.processInfo, (Object)this.timeoutSeconds);
            final Thread mainThread = Thread.currentThread();
            Timer t = new Timer(true);
            TimerTask task = new TimerTask(){

                public void run() {
                    mainThread.interrupt();
                }
            };
            t.schedule(task, (long)this.timeoutSeconds * 1000L);
            try {
                toDestroy.waitFor();
                try {
                    int exit = toDestroy.exitValue();
                    this.log.info("Process {} ended with exit code {}", (Object)this.processInfo, (Object)exit);
                }
                catch (IllegalStateException ise) {
                    this.log.error("Failed to destroy process " + this.processInfo);
                }
            }
            catch (InterruptedException e) {
                this.log.error("Timeout waiting for process " + this.processInfo + " to exit");
            }
            finally {
                t.cancel();
            }
        }
    }
}

