/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CollectionPropsWatcher;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionPropertiesZkStateReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile boolean closed = false;
    private final SolrZkClient zkClient;
    private final ZkStateReader zkStateReader;
    private final ConcurrentHashMap<String, VersionedCollectionProps> watchedCollectionProps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, PropsWatcher> collectionPropsWatchers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ZkStateReader.CollectionWatch<CollectionPropsWatcher>> collectionPropsObservers = new ConcurrentHashMap();
    private final ExecutorService collectionPropsNotifications = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new SolrNamedThreadFactory("collectionPropsNotifications"));
    private final ExecutorService notifications = ExecutorUtil.newMDCAwareCachedThreadPool((String)"cachecleaner");
    private Future<?> collectionPropsCacheCleaner;

    public CollectionPropertiesZkStateReader(ZkStateReader zkStateReader) {
        this.zkClient = zkStateReader.getZkClient();
        this.zkStateReader = zkStateReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCollectionProperties(String collection, long cacheForMillis) {
        ConcurrentHashMap<String, VersionedCollectionProps> concurrentHashMap = this.watchedCollectionProps;
        synchronized (concurrentHashMap) {
            Map<String, String> properties;
            VersionedCollectionProps vprops;
            Watcher watcher = null;
            if (cacheForMillis > 0L) {
                watcher = this.collectionPropsWatchers.compute(collection, (c, w) -> w == null ? new PropsWatcher((String)c, cacheForMillis) : w.renew(cacheForMillis));
            }
            boolean haveUnexpiredProps = (vprops = this.watchedCollectionProps.get(collection)) != null && vprops.cacheUntilNs > System.nanoTime();
            long untilNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(cacheForMillis, TimeUnit.MILLISECONDS);
            if (haveUnexpiredProps) {
                properties = vprops.props;
                vprops.cacheUntilNs = Math.max(vprops.cacheUntilNs, untilNs);
            } else {
                try {
                    VersionedCollectionProps vcp = this.fetchCollectionProperties(collection, watcher);
                    properties = vcp.props;
                    if (cacheForMillis > 0L) {
                        vcp.cacheUntilNs = untilNs;
                        this.watchedCollectionProps.put(collection, vcp);
                    } else if (!this.collectionPropsObservers.containsKey(collection)) {
                        this.watchedCollectionProps.remove(collection);
                    }
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading collection properties", SolrZkClient.checkInterrupted(e));
                }
            }
            return properties;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.notifications.shutdownNow();
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.notifications);
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.collectionPropsNotifications);
    }

    public void registerCollectionPropsWatcher(String collection, CollectionPropsWatcher propsWatcher) {
        AtomicBoolean watchSet = new AtomicBoolean(false);
        this.collectionPropsObservers.compute(collection, (k, v) -> {
            if (v == null) {
                v = new ZkStateReader.CollectionWatch();
                watchSet.set(true);
            }
            v.stateWatchers.add(propsWatcher);
            return v;
        });
        if (watchSet.get()) {
            this.collectionPropsWatchers.computeIfAbsent(collection, x$0 -> new PropsWatcher((String)x$0)).refreshAndWatch(false);
        }
    }

    protected void refreshCollectionProperties() {
        this.collectionPropsObservers.forEach((k, v) -> this.collectionPropsWatchers.computeIfAbsent((String)k, x$0 -> new PropsWatcher((String)x$0)).refreshAndWatch(true));
    }

    public static String getCollectionPropsPath(String collection) {
        return "/collections/" + collection + "/collectionprops.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionedCollectionProps fetchCollectionProperties(String collection, Watcher watcher) throws KeeperException, InterruptedException {
        String znodePath = CollectionPropertiesZkStateReader.getCollectionPropsPath(collection);
        if (this.collectionPropsCacheCleaner == null) {
            Object object = this.zkStateReader.getUpdateLock();
            synchronized (object) {
                if (this.collectionPropsCacheCleaner == null) {
                    this.collectionPropsCacheCleaner = this.notifications.submit(new CacheCleaner());
                }
            }
        }
        while (true) {
            try {
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(znodePath, watcher, stat, true);
                Map props = (Map)Utils.fromJSON((byte[])data);
                return new VersionedCollectionProps(stat.getVersion(), props);
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to parse collection properties for collection " + collection, (Throwable)e);
            }
            catch (KeeperException.NoNodeException e) {
                Stat exists;
                if (watcher != null && (exists = this.zkClient.exists(znodePath, watcher, true)) != null) continue;
                return new VersionedCollectionProps(-1, Collections.emptyMap());
            }
            break;
        }
    }

    private void notifyPropsWatchers(String collection, Map<String, String> properties) {
        block2: {
            try {
                this.collectionPropsNotifications.submit(new PropsNotification(collection, properties));
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block2;
                log.error("Couldn't run collection properties notifications for {}", (Object)collection, (Object)e);
            }
        }
    }

    public void removeCollectionPropsWatcher(String collection, CollectionPropsWatcher watcher) {
        this.collectionPropsObservers.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            v.stateWatchers.remove(watcher);
            if (v.canBeRemoved()) {
                ConcurrentHashMap<String, VersionedCollectionProps> concurrentHashMap = this.watchedCollectionProps;
                synchronized (concurrentHashMap) {
                    this.watchedCollectionProps.remove(collection);
                }
                return null;
            }
            return v;
        });
    }

    private class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                CollectionPropertiesZkStateReader.this.watchedCollectionProps.entrySet().removeIf(entry -> ((VersionedCollectionProps)entry.getValue()).cacheUntilNs < System.nanoTime() && !CollectionPropertiesZkStateReader.this.collectionPropsObservers.containsKey(entry.getKey()));
            }
        }
    }

    private class PropsNotification
    implements Runnable {
        private final String collection;
        private final Map<String, String> collectionProperties;
        private final List<CollectionPropsWatcher> watchers = new ArrayList<CollectionPropsWatcher>();

        private PropsNotification(String collection, Map<String, String> collectionProperties) {
            this.collection = collection;
            this.collectionProperties = collectionProperties;
            CollectionPropertiesZkStateReader.this.collectionPropsObservers.compute(collection, (k, v) -> {
                if (v == null) {
                    return null;
                }
                this.watchers.addAll(v.stateWatchers);
                return v;
            });
        }

        @Override
        public void run() {
            for (CollectionPropsWatcher watcher : this.watchers) {
                if (!watcher.onStateChanged(this.collectionProperties)) continue;
                CollectionPropertiesZkStateReader.this.removeCollectionPropsWatcher(this.collection, watcher);
            }
        }
    }

    class PropsWatcher
    implements Watcher {
        private final String coll;
        private long watchUntilNs;

        PropsWatcher(String coll) {
            this.coll = coll;
            this.watchUntilNs = 0L;
        }

        PropsWatcher(String coll, long forMillis) {
            this.coll = coll;
            this.watchUntilNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(forMillis, TimeUnit.MILLISECONDS);
        }

        public PropsWatcher renew(long forMillis) {
            this.watchUntilNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(forMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public void process(WatchedEvent event) {
            boolean expired;
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            boolean bl = expired = System.nanoTime() > this.watchUntilNs;
            if (!CollectionPropertiesZkStateReader.this.collectionPropsObservers.containsKey(this.coll) && expired) {
                log.debug("Ignoring property change for collection {}", (Object)this.coll);
                return;
            }
            log.info("A collection property change: [{}] for collection [{}] has occurred - updating...", (Object)event, (Object)this.coll);
            this.refreshAndWatch(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshAndWatch(boolean notifyWatchers) {
            try {
                ConcurrentHashMap<String, VersionedCollectionProps> concurrentHashMap = CollectionPropertiesZkStateReader.this.watchedCollectionProps;
                synchronized (concurrentHashMap) {
                    VersionedCollectionProps vcp = CollectionPropertiesZkStateReader.this.fetchCollectionProperties(this.coll, this);
                    Map<String, String> properties = vcp.props;
                    VersionedCollectionProps existingVcp = CollectionPropertiesZkStateReader.this.watchedCollectionProps.get(this.coll);
                    if (existingVcp == null || vcp.zkVersion > existingVcp.zkVersion || vcp.zkVersion == -1) {
                        CollectionPropertiesZkStateReader.this.watchedCollectionProps.put(this.coll, vcp);
                        if (notifyWatchers) {
                            CollectionPropertiesZkStateReader.this.notifyPropsWatchers(this.coll, properties);
                        }
                        if (vcp.zkVersion == -1 && existingVcp != null) {
                            CollectionPropertiesZkStateReader.this.watchedCollectionProps.remove(this.coll);
                            CollectionPropertiesZkStateReader.this.collectionPropsObservers.remove(this.coll);
                            CollectionPropertiesZkStateReader.this.collectionPropsWatchers.remove(this.coll);
                        }
                    }
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
            }
            catch (KeeperException e) {
                log.error("Lost collection property watcher for {} due to ZK error", (Object)this.coll, (Object)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Lost collection property watcher for {} due to the thread being interrupted", (Object)this.coll, (Object)e);
            }
        }
    }

    private static class VersionedCollectionProps {
        int zkVersion;
        Map<String, String> props;
        long cacheUntilNs = 0L;

        VersionedCollectionProps(int zkVersion, Map<String, String> props) {
            this.zkVersion = zkVersion;
            this.props = props;
        }
    }
}

