/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.LeafOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EqualsOperation
extends LeafOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();

    @Override
    public void operate(Tuple tuple) {
        this.tuple = tuple;
    }

    public EqualsOperation(String field, double val) {
        super(field, val);
    }

    public EqualsOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public boolean evaluate() {
        Double d = this.tuple.getDouble(this.field);
        if (d == null) {
            return false;
        }
        return d.doubleValue() == this.val.doubleValue();
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.field);
        expression.addParameter(Double.toString(this.val));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

