/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.UUID;
import org.apache.solr.client.solrj.io.ops.AndOperation;
import org.apache.solr.client.solrj.io.ops.BooleanOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class OrOperation
extends AndOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();

    public OrOperation(BooleanOperation leftOperand, BooleanOperation rightOperand) {
        super(leftOperand, rightOperand);
    }

    public OrOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public boolean evaluate() {
        return this.leftOperand.evaluate() || this.rightOperand.evaluate();
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (!(this.leftOperand instanceof Expressible)) {
            throw new IOException("This left operand of the OrOperation contains a non-expressible operation - it cannot be converted to an expression");
        }
        expression.addParameter(this.leftOperand.toExpression(factory));
        if (!(this.rightOperand instanceof Expressible)) {
            throw new IOException("This the right operand of the OrOperation contains a non-expressible operation - it cannot be converted to an expression");
        }
        expression.addParameter(this.rightOperand.toExpression(factory));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

