/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class StatsStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private Metric[] metrics;
    private String zkHost;
    private Tuple tuple;
    private SolrParams params;
    private String collection;
    private boolean done;
    private long count;
    private boolean doCount;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;

    @Deprecated
    public StatsStream(String zkHost, String collection, Map<String, String> props, Metric[] metrics) {
        this.init(zkHost, collection, new MapSolrParams(props), metrics);
    }

    public StatsStream(String zkHost, String collection, SolrParams params, Metric[] metrics) {
        this.init(zkHost, collection, params, metrics);
    }

    private void init(String zkHost, String collection, SolrParams params, Metric[] metrics) {
        this.zkHost = zkHost;
        this.params = params;
        this.metrics = metrics;
        this.collection = collection;
    }

    public StatsStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Metric.class);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != 1 + namedParams.size() + metricExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost")) continue;
            params.set(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        Metric[] metrics = new Metric[metricExpressions.size()];
        for (int idx = 0; idx < metricExpressions.size(); ++idx) {
            metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
        }
        this.init(zkHost, collectionName, params, metrics);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
        for (Map.Entry<String, String[]> param : mParams.getMap().entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), String.join((CharSequence)",", param.getValue())));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        for (Metric metric : this.metrics) {
            expression.addParameter(metric.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (worker ? of ?)", new Object[0]));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
        child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void open() throws IOException {
        this.cloudSolrClient = this.cache != null ? this.cache.getCloudSolrClient(this.zkHost) : new CloudSolrClient.Builder().withZkHost(this.zkHost).build();
        ModifiableSolrParams paramsLoc = new ModifiableSolrParams(this.params);
        this.addStats(paramsLoc, this.metrics);
        paramsLoc.set("stats", "true");
        paramsLoc.set("rows", "0");
        QueryRequest request = new QueryRequest(paramsLoc);
        try {
            NamedList<Object> response = this.cloudSolrClient.request(request, this.collection);
            this.tuple = this.getTuple(response);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (!this.done) {
            this.done = true;
            return this.tuple;
        }
        HashMap<String, Boolean> fields = new HashMap<String, Boolean>();
        fields.put("EOF", true);
        Tuple tuple = new Tuple(fields);
        return tuple;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    private void addStats(ModifiableSolrParams params, Metric[] _metrics) {
        HashMap<String, ArrayList<String>> m = new HashMap<String, ArrayList<String>>();
        for (Metric metric : _metrics) {
            String metricId = metric.getIdentifier();
            if (!metricId.contains("(")) continue;
            metricId = metricId.substring(0, metricId.length() - 1);
            String[] parts = metricId.split("\\(");
            String function = parts[0];
            String column = parts[1];
            ArrayList<String> stats = (ArrayList<String>)m.get(column);
            if (stats == null && !column.equals("*")) {
                stats = new ArrayList<String>();
                m.put(column, stats);
            }
            if (function.equals("min")) {
                stats.add("min");
                continue;
            }
            if (function.equals("max")) {
                stats.add("max");
                continue;
            }
            if (function.equals("sum")) {
                stats.add("sum");
                continue;
            }
            if (function.equals("avg")) {
                stats.add("mean");
                continue;
            }
            if (!function.equals("count")) continue;
            this.doCount = true;
        }
        for (String field : m.keySet()) {
            StringBuilder buf = new StringBuilder();
            List stats = (List)m.get(field);
            buf.append("{!");
            for (String stat : stats) {
                buf.append(stat).append("=").append("true ");
            }
            buf.append("}").append(field);
            params.add("stats.field", buf.toString());
        }
    }

    private Tuple getTuple(NamedList response) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (this.doCount) {
            SolrDocumentList solrDocumentList = (SolrDocumentList)response.get("response");
            this.count = solrDocumentList.getNumFound();
            map.put("count(*)", this.count);
        }
        NamedList stats = (NamedList)response.get("stats");
        NamedList statsFields = (NamedList)stats.get("stats_fields");
        for (int i = 0; i < statsFields.size(); ++i) {
            String field = statsFields.getName(i);
            NamedList theStats = (NamedList)statsFields.getVal(i);
            for (int s = 0; s < theStats.size(); ++s) {
                this.addStat(map, field, theStats.getName(s), theStats.getVal(s));
            }
        }
        Tuple tuple = new Tuple(map);
        return tuple;
    }

    @Override
    public int getCost() {
        return 0;
    }

    private void addStat(Map map, String field, String stat, Object val) {
        if (stat.equals("mean")) {
            map.put("avg(" + field + ")", val);
        } else {
            map.put(stat + "(" + field + ")", val);
        }
    }
}

