/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SelectStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private Map<String, String> selectedFields;
    private List<StreamOperation> operations;

    public SelectStream(TupleStream stream, List<String> selectedFields) throws IOException {
        this.stream = stream;
        this.selectedFields = new HashMap<String, String>();
        for (String selectedField : selectedFields) {
            this.selectedFields.put(selectedField, selectedField);
        }
        this.operations = new ArrayList<StreamOperation>();
    }

    public SelectStream(TupleStream stream, Map<String, String> selectedFields) throws IOException {
        this.stream = stream;
        this.selectedFields = selectedFields;
        this.operations = new ArrayList<StreamOperation>();
    }

    public SelectStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        List<StreamExpressionParameter> selectFieldsExpressions = factory.getOperandsOfType(expression, StreamExpressionValue.class);
        List<StreamExpression> operationExpressions = factory.getExpressionOperandsRepresentingTypes(expression, StreamOperation.class);
        if (expression.getParameters().size() != streamExpressions.size() + selectFieldsExpressions.size() + operationExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single stream but found %d (must be TupleStream types)", expression, streamExpressions.size()));
        }
        if (0 == selectFieldsExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one select field but found %d", expression, streamExpressions.size()));
        }
        this.stream = factory.constructStream(streamExpressions.get(0));
        this.selectedFields = new HashMap<String, String>(selectFieldsExpressions.size());
        for (StreamExpressionParameter parameter : selectFieldsExpressions) {
            StreamExpressionValue selectField = (StreamExpressionValue)parameter;
            String value = selectField.getValue().trim();
            if (value.length() > 2 && value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.toLowerCase(Locale.ROOT).contains(" as ")) {
                String[] parts = value.split("(?i) as ");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting select field of form 'fieldA' or 'fieldA as alias' but found %s", expression, value));
                }
                this.selectedFields.put(parts[0].trim(), parts[1].trim());
                continue;
            }
            this.selectedFields.put(value, value);
        }
        this.operations = new ArrayList<StreamOperation>();
        for (StreamExpression expr : operationExpressions) {
            this.operations.add(factory.constructOperation(expr));
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.stream instanceof Expressible)) throw new IOException("This SelectStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        for (Map.Entry<String, String> selectField : this.selectedFields.entrySet()) {
            if (selectField.getKey().equals(selectField.getValue())) {
                expression.addParameter(selectField.getKey());
                continue;
            }
            expression.addParameter(String.format(Locale.ROOT, "%s as %s", selectField.getKey(), selectField.getValue()));
        }
        for (StreamOperation operation : this.operations) {
            expression.addParameter(operation.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        Explanation explanation = new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
        for (StreamOperation operation : this.operations) {
            explanation.addHelper(operation.toExplanation(factory));
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple original = this.stream.read();
        if (original.EOF) {
            return original;
        }
        Tuple working = new Tuple(new HashMap());
        for (Object fieldName : original.fields.keySet()) {
            if (!this.selectedFields.containsKey(fieldName)) continue;
            working.put(this.selectedFields.get(fieldName), original.get(fieldName));
        }
        for (StreamOperation operation : this.operations) {
            operation.operate(working);
        }
        return working;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort().copyAliased(this.selectedFields);
    }

    @Override
    public int getCost() {
        return 0;
    }
}

