/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class Metric
implements Expressible {
    private UUID metricNodeId = UUID.randomUUID();
    private String functionName;
    private String identifier;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setIdentifier(String ... identifierParts) {
        StringBuilder sb = new StringBuilder();
        for (String part : identifierParts) {
            sb.append(part);
        }
        this.identifier = sb.toString();
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.getMetricNodeId().toString()).withFunctionName(this.functionName).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString()).withExpressionType("metric");
    }

    public UUID getMetricNodeId() {
        return this.metricNodeId;
    }

    public abstract Number getValue();

    public abstract void update(Tuple var1);

    public abstract Metric newInstance();

    public abstract String[] getColumns();
}

