/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.util.Pair;

public class MoveReplicaSuggester
extends Policy.Suggester {
    @Override
    SolrRequest init() {
        SolrRequest operation = this.tryEachNode(true);
        if (operation == null) {
            operation = this.tryEachNode(false);
        }
        return operation;
    }

    SolrRequest tryEachNode(boolean strict) {
        List<Clause.Violation> leastSeriousViolation = null;
        Integer targetNodeIndex = null;
        Integer sourceNodeIndex = null;
        Policy.ReplicaInfo fromReplicaInfo = null;
        for (Pair<Policy.ReplicaInfo, Row> fromReplica : this.getValidReplicas(true, true, -1)) {
            Row fromRow = fromReplica.second();
            Policy.ReplicaInfo replicaInfo = fromReplica.first();
            String coll = replicaInfo.collection;
            String shard = replicaInfo.shard;
            Pair<Row, Policy.ReplicaInfo> pair = fromRow.removeReplica(coll, shard);
            Row tmpRow = pair.first();
            if (tmpRow == null) continue;
            tmpRow.violations.clear();
            int i = this.getMatrix().indexOf(fromRow);
            for (int j = this.getMatrix().size() - 1; j > i; --j) {
                Row targetRow = this.getMatrix().get(j);
                if (!this.isAllowed(targetRow.node, Policy.Suggester.Hint.TARGET_NODE)) continue;
                targetRow = targetRow.addReplica(coll, shard);
                targetRow.violations.clear();
                List<Clause.Violation> errs = this.testChangedMatrix(strict, this.getModifiedMatrix(this.getModifiedMatrix(this.getMatrix(), tmpRow, i), targetRow, j));
                if (this.containsNewErrors(errs) || !this.isLessSerious(errs, leastSeriousViolation)) continue;
                leastSeriousViolation = errs;
                targetNodeIndex = j;
                sourceNodeIndex = i;
                fromReplicaInfo = replicaInfo;
            }
        }
        if (targetNodeIndex != null && sourceNodeIndex != null) {
            this.getMatrix().set(sourceNodeIndex, this.getMatrix().get(sourceNodeIndex).removeReplica(fromReplicaInfo.collection, fromReplicaInfo.shard).first());
            this.getMatrix().set(targetNodeIndex, this.getMatrix().get(targetNodeIndex).addReplica(fromReplicaInfo.collection, fromReplicaInfo.shard));
            return new CollectionAdminRequest.MoveReplica(fromReplicaInfo.collection, fromReplicaInfo.name, this.getMatrix().get((int)targetNodeIndex.intValue()).node);
        }
        return null;
    }
}

