/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.ClusterDataProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Utils;

public class PolicyHelper {
    public static Map<String, List<String>> getReplicaLocations(String collName, Map<String, Object> autoScalingJson, ClusterDataProvider cdp, final Map<String, String> optionalPolicyMapping, List<String> shardNames, int repFactor, List<String> nodesList) {
        HashMap<String, List<String>> positionMapping = new HashMap<String, List<String>>();
        for (String shardName : shardNames) {
            positionMapping.put(shardName, new ArrayList(repFactor));
        }
        if (optionalPolicyMapping != null) {
            final ClusterDataProvider delegate = cdp;
            cdp = new ClusterDataProvider(){

                @Override
                public Map<String, Object> getNodeValues(String node, Collection<String> tags) {
                    return delegate.getNodeValues(node, tags);
                }

                @Override
                public Map<String, Map<String, List<Policy.ReplicaInfo>>> getReplicaInfo(String node, Collection<String> keys) {
                    return delegate.getReplicaInfo(node, keys);
                }

                @Override
                public Collection<String> getNodes() {
                    return delegate.getNodes();
                }

                @Override
                public String getPolicyNameByCollection(String coll) {
                    return optionalPolicyMapping.containsKey(coll) ? (String)optionalPolicyMapping.get(coll) : delegate.getPolicyNameByCollection(coll);
                }
            };
        }
        Policy policy = new Policy(autoScalingJson);
        Policy.Session session = policy.createSession(cdp);
        for (String shardName : shardNames) {
            for (int i = 0; i < repFactor; ++i) {
                SolrRequest op;
                Policy.Suggester suggester = session.getSuggester(CollectionParams.CollectionAction.ADDREPLICA).hint(Policy.Suggester.Hint.COLL, collName).hint(Policy.Suggester.Hint.SHARD, shardName);
                if (nodesList != null) {
                    for (String nodeName : nodesList) {
                        suggester = suggester.hint(Policy.Suggester.Hint.TARGET_NODE, nodeName);
                    }
                }
                if ((op = suggester.getOperation()) == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No node can satisfy the rules " + Utils.toJSONString(Utils.getDeepCopy(session.expandedClauses, 4, true)));
                }
                session = suggester.getSession();
                ((List)positionMapping.get(shardName)).add(op.getParams().get("node"));
            }
        }
        return positionMapping;
    }
}

