/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.inference.OneWayAnova;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class AnovaEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public AnovaEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.subEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Tuple evaluate(Tuple tuple) throws IOException {
        ArrayList<double[]> list = new ArrayList<double[]>();
        for (StreamEvaluator subEvaluator : this.subEvaluators) {
            List nums = (List)subEvaluator.evaluate(tuple);
            double[] darray = new double[nums.size()];
            for (int i = 0; i < nums.size(); ++i) {
                darray[i] = ((Number)nums.get(i)).doubleValue();
            }
            list.add(darray);
        }
        OneWayAnova anova = new OneWayAnova();
        double p = anova.anovaPValue(list);
        double f = anova.anovaFValue(list);
        HashMap<String, Double> m = new HashMap<String, Double>();
        m.put("p-value", p);
        m.put("f-ratio", f);
        return new Tuple(m);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

