/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EmpiricalDistributionEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public EmpiricalDistributionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one column but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Tuple evaluate(Tuple tuple) throws IOException {
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        List numbers1 = (List)colEval1.evaluate(tuple);
        double[] column1 = new double[numbers1.size()];
        for (int i = 0; i < numbers1.size(); ++i) {
            column1[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        Arrays.sort(column1);
        EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution();
        empiricalDistribution.load(column1);
        HashMap<String, Number> map = new HashMap<String, Number>();
        StatisticalSummary statisticalSummary = empiricalDistribution.getSampleStats();
        map.put("max", statisticalSummary.getMax());
        map.put("mean", statisticalSummary.getMean());
        map.put("min", statisticalSummary.getMin());
        map.put("stdev", statisticalSummary.getStandardDeviation());
        map.put("sum", statisticalSummary.getSum());
        map.put("N", statisticalSummary.getN());
        map.put("var", statisticalSummary.getVariance());
        return new EmpiricalDistributionTuple(empiricalDistribution, column1, map);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    public static class EmpiricalDistributionTuple
    extends Tuple {
        private EmpiricalDistribution empiricalDistribution;
        private double[] backingArray;

        public EmpiricalDistributionTuple(EmpiricalDistribution empiricalDistribution, double[] backingArray, Map map) {
            super(map);
            this.empiricalDistribution = empiricalDistribution;
            this.backingArray = backingArray;
        }

        public double percentile(double d) {
            int slot = Arrays.binarySearch(this.backingArray, d);
            if (slot == 0) {
                return 0.0;
            }
            if (slot < 0) {
                if (slot == -1) {
                    return 0.0;
                }
                slot = Math.abs(slot);
                if (--slot == this.backingArray.length) {
                    return 1.0;
                }
                return this.empiricalDistribution.cumulativeProbability(this.backingArray[slot]);
            }
            return this.empiricalDistribution.cumulativeProbability(this.backingArray[slot]);
        }
    }
}

