/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FindDelayEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public FindDelayEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Number evaluate(Tuple tuple) throws IOException {
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        StreamEvaluator colEval2 = (StreamEvaluator)this.subEvaluators.get(1);
        List numbers1 = (List)colEval1.evaluate(tuple);
        List numbers2 = (List)colEval2.evaluate(tuple);
        double[] column1 = new double[numbers1.size()];
        double[] column2 = new double[numbers2.size()];
        for (int i = 0; i < numbers1.size(); ++i) {
            column1[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        int rIndex = 0;
        for (int i = numbers2.size() - 1; i >= 0; --i) {
            column2[rIndex++] = ((Number)numbers2.get(i)).doubleValue();
        }
        double[] convolution = MathArrays.convolve((double[])column1, (double[])column2);
        double max = -1.7976931348623157E308;
        double maxIndex = -1.0;
        for (int i = 0; i < convolution.length; ++i) {
            double abs = Math.abs(convolution[i]);
            if (!(abs > max)) continue;
            max = abs;
            maxIndex = i;
        }
        return maxIndex + 1.0 - (double)column2.length;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

